/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.contour;

import java.util.List;
import org.jzy3d.maths.Array;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.LineStrip;
import org.jzy3d.plot3d.primitives.contour.ILineStripMergePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLineStripMergePolicy
implements ILineStripMergePolicy {
    protected double threshold = 0.0;

    public DefaultLineStripMergePolicy() {
        this.threshold = 2.0;
    }

    public DefaultLineStripMergePolicy(double threshold) {
        this.threshold = threshold;
    }

    @Override
    public LineStrip mostMergeableIfAny(LineStrip ls, List<LineStrip> lines) {
        if (lines.size() == 0) {
            return null;
        }
        double[] scores = new double[lines.size()];
        int k = 0;
        for (LineStrip line : lines) {
            scores[k++] = this.mergeScore(line, ls);
        }
        int[] ids = Array.sortAscending(scores);
        if (scores[0] < this.threshold) {
            return lines.get(ids[0]);
        }
        return null;
    }

    @Override
    public boolean mergeable(LineStrip ls1, LineStrip ls2) {
        return this.mergeScore(ls1, ls2) < this.threshold;
    }

    @Override
    public double mergeScore(LineStrip ls1, LineStrip ls2) {
        return this.minDist(ls1, ls2);
    }

    protected double minDist(LineStrip strip1, LineStrip strip2) {
        Coord3d a = strip1.get((int)0).xyz;
        Coord3d b = strip1.get((int)(strip1.size() - 1)).xyz;
        Coord3d c = strip2.get((int)0).xyz;
        Coord3d d = strip2.get((int)(strip2.size() - 1)).xyz;
        double bc = b.distance(c);
        double da = d.distance(a);
        return Math.min(bc, da);
    }
}

