/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.enlightables;

import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.events.DrawableChangedEvent;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Normal;
import org.jzy3d.maths.Utils;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.primitives.enlightables.AbstractEnlightable;
import org.jzy3d.plot3d.rendering.view.Camera;

public class EnlightablePolygon
extends AbstractEnlightable {
    private boolean hasAlpha = false;
    protected ColorMapper mapper;
    protected List<Point> points = new ArrayList<Point>(4);
    protected Color color;
    protected Coord3d center;

    public EnlightablePolygon() {
        this.bbox = new BoundingBox3d();
        this.center = new Coord3d();
    }

    public void draw(GL2 gl, GLU glu, Camera cam) {
        if (this.transform != null) {
            this.transform.execute(gl);
        }
        this.applyMaterial(gl);
        Coord3d norm = Normal.compute(this.points.get((int)0).xyz, this.points.get((int)1).xyz, this.points.get((int)2).xyz);
        if (this.facestatus) {
            gl.glPolygonMode(1032, 6914);
            if (this.wfstatus) {
                gl.glEnable(32823);
                gl.glPolygonOffset(1.0f, 1.0f);
            }
            gl.glBegin(9);
            for (Point p : this.points) {
                if (this.mapper != null) {
                    Color c = this.mapper.getColor(p.xyz);
                    gl.glColor4f(c.r, c.g, c.b, c.a);
                } else {
                    gl.glColor4f(p.rgb.r, p.rgb.g, p.rgb.b, p.rgb.a);
                }
                gl.glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
                gl.glNormal3f(norm.x, norm.y, norm.z);
            }
            gl.glEnd();
            if (this.wfstatus) {
                gl.glDisable(32823);
            }
        }
        if (this.wfstatus) {
            gl.glPolygonMode(1032, 6913);
            gl.glEnable(32823);
            gl.glPolygonOffset(1.0f, 1.0f);
            gl.glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, 1.0f);
            gl.glLineWidth(this.wfwidth);
            gl.glBegin(9);
            for (Point p : this.points) {
                gl.glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
                gl.glNormal3f(norm.x, norm.y, norm.z);
            }
            gl.glEnd();
            gl.glDisable(32823);
        }
    }

    public void add(Point point) {
        if (point.rgb.a < 1.0f) {
            this.hasAlpha = true;
        }
        this.points.add(point);
        this.bbox.add(point);
        this.center = new Coord3d();
        for (Point p : this.points) {
            this.center = this.center.add(p.xyz);
        }
        this.center = this.center.div(this.points.size());
    }

    public boolean hasAlpha() {
        return this.hasAlpha;
    }

    public Coord3d getBarycentre() {
        return this.center;
    }

    public Point get(int p) {
        return this.points.get(p);
    }

    public int size() {
        return this.points.size();
    }

    public void setColorMapper(ColorMapper mapper) {
        this.mapper = mapper;
        this.fireDrawableChanged(new DrawableChangedEvent(this, 2));
    }

    public ColorMapper getColorMapper() {
        return this.mapper;
    }

    public void setColor(Color color) {
        this.color = color;
        for (Point p : this.points) {
            p.setColor(color);
        }
        this.fireDrawableChanged(new DrawableChangedEvent(this, 2));
    }

    public Color getColor() {
        return this.color;
    }

    public String toString(int depth) {
        return Utils.blanks(depth) + "(EnlightablePolygon) #points:" + this.points.size();
    }
}

