/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.graphs.impl;

import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.graphs.AbstractDrawableGraph2d;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.text.align.Halign;
import org.jzy3d.plot3d.text.align.Valign;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDrawableGraph2d<V, E>
extends AbstractDrawableGraph2d<V, E> {
    public DefaultDrawableGraph2d() {
        this.bbox = new BoundingBox3d();
        this.labelScreenOffset = new Coord2d(0.0f, 0.0f);
        this.labelSceneOffset = new Coord3d(0.0f, 0.0f, 0.0f);
    }

    @Override
    protected void drawVertices(GL2 gl, GLU glu, Camera cam) {
        gl.glPointSize((float)this.formatter.getVertexWidth());
        gl.glBegin(0);
        for (Object v : this.graph.getVertices()) {
            if (((Boolean)this.highlights.get(v)).booleanValue()) {
                this.drawVertexNode(gl, glu, cam, v, this.layout.get(v), this.formatter.getHighlightedVertexColor());
                continue;
            }
            this.drawVertexNode(gl, glu, cam, v, this.layout.get(v), this.formatter.getVertexColor());
        }
        gl.glEnd();
    }

    @Override
    protected void drawVertexLabels(GL2 gl, GLU glu, Camera cam) {
        for (Object v : this.graph.getVertices()) {
            if (((Boolean)this.highlights.get(v)).booleanValue()) {
                this.drawVertexLabel(gl, glu, cam, v, this.layout.get(v), this.formatter.getHighlightedVertexColor());
                continue;
            }
            this.drawVertexLabel(gl, glu, cam, v, this.layout.get(v), this.formatter.getVertexLabelColor());
        }
    }

    @Override
    protected void drawEdges(GL2 gl, GLU glu, Camera cam) {
        for (Object e : this.graph.getEdges()) {
            Object v1 = this.graph.getEdgeStartVertex(e);
            Object v2 = this.graph.getEdgeStopVertex(e);
            this.drawEdge(gl, glu, cam, e, this.layout.get(v1), this.layout.get(v2), this.formatter.getEdgeColor());
        }
    }

    protected void drawVertexNode(GL2 gl, GLU glu, Camera cam, V v, Coord2d coord, Color color) {
        gl.glColor4f(color.r, color.g, color.b, color.a);
        gl.glVertex3f(coord.x, coord.y, Z);
    }

    protected void drawVertexLabel(GL2 gl, GLU glu, Camera cam, V v, Coord2d coord, Color color) {
        Coord3d textPosition = new Coord3d(coord, Z);
        this.txt.drawText(gl, glu, cam, v.toString(), textPosition, Halign.CENTER, Valign.BOTTOM, color, this.labelScreenOffset, this.labelSceneOffset);
    }

    protected void drawEdge(GL2 gl, GLU glu, Camera cam, E e, Coord2d c1, Coord2d c2, Color color) {
        gl.glBegin(3);
        gl.glColor4f(color.r, color.g, color.b, color.a);
        gl.glVertex3f(c1.x, c1.y, Z);
        gl.glVertex3f(c2.x, c2.y, Z);
        gl.glEnd();
    }
}

