/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.textured;

import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureCoords;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.BoundingBox2d;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.PlaneAxis;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.textured.ITranslucent;
import org.jzy3d.plot3d.rendering.textures.SharedTexture;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.transform.Transform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawableTexture
extends AbstractDrawable
implements ITranslucent {
    protected Transform textureScale;
    protected SharedTexture resource;
    protected PlaneAxis orientation;
    protected float[] texMatMix = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    protected Color filter;
    protected float axisValue;
    protected List<Coord2d> mapping;
    protected float alpha = 1.0f;
    protected Coord2d planePosition = new Coord2d();

    public DrawableTexture(SharedTexture resource) {
        this(resource, PlaneAxis.Z, 0.0f, null, null);
    }

    public DrawableTexture(SharedTexture resource, PlaneAxis orientation) {
        this(resource, orientation, 0.0f, null, null);
    }

    public DrawableTexture(SharedTexture resource, PlaneAxis orientation, float axisValue) {
        this(resource, orientation, axisValue, null, null);
    }

    public DrawableTexture(SharedTexture resource, PlaneAxis orientation, float axisValue, Color filter) {
        this(resource, orientation, axisValue, null, filter);
    }

    public DrawableTexture(SharedTexture resource, PlaneAxis orientation, float axisValue, List<Coord2d> coords) {
        this(resource, orientation, axisValue, coords, null);
    }

    public DrawableTexture(SharedTexture resource, PlaneAxis orientation, float axisValue, List<Coord2d> coords, Color filter) {
        this.resource = resource;
        this.axisValue = axisValue;
        this.orientation = orientation;
        this.filter = filter == null ? Color.WHITE.clone() : filter;
        if (coords != null) {
            this.mapping = coords;
            this.initBoundsWithMapping();
        } else {
            this.mapping = this.getDefaultTextureMapping();
            this.initBoundsWithMapping();
        }
    }

    public Color getColorFilter() {
        return this.filter;
    }

    public void setColorFilter(Color filter) {
        this.filter = filter;
    }

    @Override
    public void setAlphaFactor(float a) {
        this.alpha = a;
    }

    protected void initBoundsWithMapping() {
        BoundingBox2d box = new BoundingBox2d(this.mapping);
        float enlarge = 1.0f;
        if (this.orientation == PlaneAxis.X) {
            this.bbox = new BoundingBox3d(this.axisValue - enlarge, this.axisValue + enlarge, box.xmin(), box.xmax(), box.ymin(), box.ymax());
        } else if (this.orientation == PlaneAxis.Y) {
            this.bbox = new BoundingBox3d(box.xmin(), box.xmax(), this.axisValue - enlarge, this.axisValue + enlarge, box.ymin(), box.ymax());
        } else if (this.orientation == PlaneAxis.Z) {
            this.bbox = new BoundingBox3d(box.xmin(), box.xmax(), box.ymin(), box.ymax(), this.axisValue - enlarge, this.axisValue + enlarge);
        }
    }

    protected void initBoundsWithResources() {
        float enlarge = 1.0f;
        if (this.orientation == PlaneAxis.X) {
            this.bbox = new BoundingBox3d(this.axisValue - enlarge, this.axisValue + enlarge, -this.resource.getHalfWidth(), this.resource.getHalfWidth(), -this.resource.getHalfHeight(), this.resource.getHalfHeight());
        } else if (this.orientation == PlaneAxis.Y) {
            this.bbox = new BoundingBox3d(-this.resource.getHalfWidth(), this.resource.getHalfWidth(), this.axisValue - enlarge, this.axisValue + enlarge, -this.resource.getHalfHeight(), this.resource.getHalfHeight());
        } else if (this.orientation == PlaneAxis.Z) {
            this.bbox = new BoundingBox3d(-this.resource.getHalfWidth(), this.resource.getHalfWidth(), -this.resource.getHalfHeight(), this.resource.getHalfHeight(), this.axisValue - enlarge, this.axisValue + enlarge);
        }
    }

    protected List<Coord2d> getDefaultTextureMapping() {
        ArrayList<Coord2d> mapping = new ArrayList<Coord2d>(4);
        mapping.add(new Coord2d(-this.resource.getHalfWidth(), -this.resource.getHalfHeight()));
        mapping.add(new Coord2d(this.resource.getHalfWidth(), -this.resource.getHalfHeight()));
        mapping.add(new Coord2d(this.resource.getHalfWidth(), this.resource.getHalfHeight()));
        mapping.add(new Coord2d(-this.resource.getHalfWidth(), this.resource.getHalfHeight()));
        return mapping;
    }

    public static List<Coord2d> getManualTextureMapping(float width, float height, float xoffset, float yoffset) {
        ArrayList<Coord2d> mapping = new ArrayList<Coord2d>(4);
        mapping.add(new Coord2d(xoffset - width / 2.0f, yoffset - height / 2.0f));
        mapping.add(new Coord2d(xoffset + width / 2.0f, yoffset - height / 2.0f));
        mapping.add(new Coord2d(xoffset + width / 2.0f, yoffset + height / 2.0f));
        mapping.add(new Coord2d(xoffset - width / 2.0f, yoffset + height / 2.0f));
        return mapping;
    }

    public static List<Coord2d> getManualTextureMapping(float width, float height) {
        return DrawableTexture.getManualTextureMapping(width, height, 0.0f, 0.0f);
    }

    public void debugMapping() {
        System.out.println("mapping");
        for (Coord2d c : this.mapping) {
            System.out.println(c);
        }
    }

    @Override
    public BoundingBox3d getBounds() {
        return this.bbox.shift(new Coord3d(this.planePosition, 0.0f));
    }

    public Coord2d getPlanePosition() {
        return this.planePosition;
    }

    public void setPlanePosition(Coord2d planePosition) {
        this.planePosition = planePosition;
    }

    public Transform getTextureScale() {
        return this.textureScale;
    }

    public void setTextureScale(Transform textureScale) {
        this.textureScale = textureScale;
    }

    @Override
    public void draw(GL2 gl, GLU glu, Camera cam) {
        if (this.transform != null) {
            this.transform.execute(gl);
        }
        if (this.textureScale != null) {
            this.textureScale.execute(gl, false);
        }
        Texture texture = this.resource.getTexture(gl);
        TextureCoords coords = this.resource.getCoords();
        texture.bind((GL)gl);
        this.callWithAlphaFactor(gl, this.filter, this.alpha);
        this.before(gl);
        gl.glBegin(7);
        if (this.orientation == PlaneAxis.X) {
            gl.glTexCoord2f(coords.left(), coords.bottom());
            gl.glVertex3f(this.axisValue, this.mapping.get((int)0).x, this.mapping.get((int)0).y);
            gl.glTexCoord2f(coords.right(), coords.bottom());
            gl.glVertex3f(this.axisValue, this.mapping.get((int)1).x, this.mapping.get((int)1).y);
            gl.glTexCoord2f(coords.right(), coords.top());
            gl.glVertex3f(this.axisValue, this.mapping.get((int)2).x, this.mapping.get((int)2).y);
            gl.glTexCoord2f(coords.left(), coords.top());
            gl.glVertex3f(this.axisValue, this.mapping.get((int)3).x, this.mapping.get((int)3).y);
        } else if (this.orientation == PlaneAxis.Y) {
            gl.glTexCoord2f(coords.left(), coords.bottom());
            gl.glVertex3f(this.mapping.get((int)0).x, this.axisValue, this.mapping.get((int)0).y);
            gl.glTexCoord2f(coords.right(), coords.bottom());
            gl.glVertex3f(this.mapping.get((int)1).x, this.axisValue, this.mapping.get((int)1).y);
            gl.glTexCoord2f(coords.right(), coords.top());
            gl.glVertex3f(this.mapping.get((int)2).x, this.axisValue, this.mapping.get((int)2).y);
            gl.glTexCoord2f(coords.left(), coords.top());
            gl.glVertex3f(this.mapping.get((int)3).x, this.axisValue, this.mapping.get((int)3).y);
        } else if (this.orientation == PlaneAxis.Z) {
            gl.glTexCoord2f(coords.left(), coords.bottom());
            gl.glVertex3f(this.planePosition.x + this.mapping.get((int)0).x, this.planePosition.y + this.mapping.get((int)0).y, this.axisValue);
            gl.glTexCoord2f(coords.right(), coords.bottom());
            gl.glVertex3f(this.planePosition.x + this.mapping.get((int)1).x, this.planePosition.y + this.mapping.get((int)1).y, this.axisValue);
            gl.glTexCoord2f(coords.right(), coords.top());
            gl.glVertex3f(this.planePosition.x + this.mapping.get((int)2).x, this.planePosition.y + this.mapping.get((int)2).y, this.axisValue);
            gl.glTexCoord2f(coords.left(), coords.top());
            gl.glVertex3f(this.planePosition.x + this.mapping.get((int)3).x, this.planePosition.y + this.mapping.get((int)3).y, this.axisValue);
        }
        gl.glEnd();
        this.after(gl);
    }

    protected void before(GL2 gl) {
        gl.glPushMatrix();
        gl.glPolygonMode(1032, 6914);
        gl.glEnable(3553);
        gl.glTexEnvf(3553, 8704, 7681.0f);
    }

    protected void after(GL2 gl) {
        gl.glDisable(3553);
        gl.glTexEnvi(8960, 8704, 8448);
        gl.glPopMatrix();
    }

    public SharedTexture getResource() {
        return this.resource;
    }

    public void setResource(SharedTexture resource) {
        this.resource = resource;
    }
}

