/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.textured;

import java.awt.Polygon;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.ConvexHull;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.PlaneAxis;
import org.jzy3d.plot3d.primitives.AbstractComposite;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.primitives.selectable.Selectable;
import org.jzy3d.plot3d.primitives.textured.DrawableTexture;
import org.jzy3d.plot3d.primitives.textured.ITranslucent;
import org.jzy3d.plot3d.primitives.textured.MaskPair;
import org.jzy3d.plot3d.primitives.textured.TranslucentQuad;
import org.jzy3d.plot3d.rendering.view.Camera;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TexturedCylinder
extends AbstractComposite
implements Selectable,
ITranslucent {
    protected AbstractDrawable dArrowUp;
    protected AbstractDrawable dArrowDown;
    protected AbstractDrawable dDiskUp;
    protected AbstractDrawable dDiskDown;
    protected List<TranslucentQuad> quads;
    protected List<Coord3d> lastProjection;
    protected Polygon lastHull;
    protected float alpha = 1.0f;

    public TexturedCylinder(MaskPair masks) {
        this(new Coord3d(), Color.CYAN, Color.RED, masks);
    }

    public TexturedCylinder(Coord3d position, MaskPair masks) {
        this(position, Color.CYAN, Color.RED, masks);
    }

    public TexturedCylinder(Coord3d position, Color color, Color bgcolor, MaskPair masks) {
        ArrayList<Coord2d> mapping = new ArrayList<Coord2d>(4);
        mapping.add(new Coord2d((double)position.x - 0.5, (double)position.y - 0.5));
        mapping.add(new Coord2d((double)position.x + 0.5, (double)position.y - 0.5));
        mapping.add(new Coord2d((double)position.x + 0.5, (double)position.y + 0.5));
        mapping.add(new Coord2d((double)position.x - 0.5, (double)position.y + 0.5));
        this.dDiskDown = new DrawableTexture(masks.bgMask, PlaneAxis.Z, position.z - 0.5f, mapping, bgcolor);
        this.dDiskUp = new DrawableTexture(masks.bgMask, PlaneAxis.Z, position.z + 0.5f, mapping, bgcolor);
        this.dArrowDown = new DrawableTexture(masks.symbolMask, PlaneAxis.Z, position.z - 0.5f, mapping, color);
        this.dArrowUp = new DrawableTexture(masks.symbolMask, PlaneAxis.Z, position.z + 0.5f, mapping, color);
        int slices = 20;
        float radius = 0.5f;
        float height = 1.0f;
        Coord3d pos = new Coord3d(position.x, position.y, position.z - 0.5f);
        this.quads = new ArrayList<TranslucentQuad>(slices);
        for (int i = 0; i < slices; ++i) {
            float angleBorder1 = (float)i * 2.0f * (float)Math.PI / (float)slices;
            float angleBorder2 = (float)(i + 1) * 2.0f * (float)Math.PI / (float)slices;
            Coord2d border1 = new Coord2d(angleBorder1, radius).cartesian();
            Coord2d border2 = new Coord2d(angleBorder2, radius).cartesian();
            TranslucentQuad face = new TranslucentQuad();
            face.add(new Point(new Coord3d(pos.x + border1.x, pos.y + border1.y, pos.z)));
            face.add(new Point(new Coord3d(pos.x + border1.x, pos.y + border1.y, pos.z + height)));
            face.add(new Point(new Coord3d(pos.x + border2.x, pos.y + border2.y, pos.z + height)));
            face.add(new Point(new Coord3d(pos.x + border2.x, pos.y + border2.y, pos.z)));
            face.setColor(bgcolor);
            face.setWireframeDisplayed(false);
            this.quads.add(face);
        }
        this.add(this.dDiskDown);
        this.add(this.dArrowDown);
        this.add(this.dDiskUp);
        this.add(this.dArrowUp);
        this.add(this.quads);
        this.bbox = new BoundingBox3d();
        for (TranslucentQuad quad : this.quads) {
            this.bbox.add(quad);
        }
    }

    @Override
    public void setAlphaFactor(float a) {
        this.alpha = a;
        ((DrawableTexture)this.dDiskDown).setAlphaFactor(this.alpha);
        ((DrawableTexture)this.dArrowDown).setAlphaFactor(this.alpha);
        ((DrawableTexture)this.dDiskUp).setAlphaFactor(this.alpha);
        ((DrawableTexture)this.dArrowUp).setAlphaFactor(this.alpha);
        for (TranslucentQuad q : this.quads) {
            q.setAlphaFactor(this.alpha);
        }
    }

    @Override
    public BoundingBox3d getBounds() {
        return this.bbox;
    }

    @Override
    public void project(GL2 gl, GLU glu, Camera cam) {
        this.lastProjection = cam.modelToScreen(gl, glu, this.getBounds().getVertices());
        this.lastHull = ConvexHull.hull(this.lastProjection);
    }

    @Override
    public Polygon getHull2d() {
        return this.lastHull;
    }

    @Override
    public List<Coord3d> getLastProjection() {
        return this.lastProjection;
    }
}

