/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.textured;

import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.jzy3d.colors.Color;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.primitives.Quad;
import org.jzy3d.plot3d.primitives.textured.ITranslucent;
import org.jzy3d.plot3d.rendering.view.Camera;

public class TranslucentQuad
extends Quad
implements ITranslucent {
    protected float alpha = 1.0f;

    public void draw(GL2 gl, GLU glu, Camera cam) {
        if (this.transform != null) {
            this.transform.execute(gl);
        }
        if (this.facestatus) {
            gl.glPolygonMode(1032, 6914);
            if (this.wfstatus) {
                gl.glEnable(32823);
                gl.glPolygonOffset(1.0f, 1.0f);
            }
            gl.glBegin(7);
            for (Point p : this.points) {
                if (this.mapper != null) {
                    Color c = this.mapper.getColor(p.xyz);
                    this.callWithAlphaFactor(gl, c, this.alpha);
                } else {
                    this.callWithAlphaFactor(gl, p.rgb, this.alpha);
                }
                gl.glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
            }
            gl.glEnd();
            if (this.wfstatus) {
                gl.glDisable(32823);
            }
        }
        if (this.wfstatus) {
            gl.glPolygonMode(1032, 6913);
            gl.glEnable(32823);
            gl.glPolygonOffset(1.0f, 1.0f);
            this.callWithAlphaFactor(gl, this.wfcolor, this.alpha);
            gl.glLineWidth(this.wfwidth);
            gl.glBegin(7);
            for (Point p : this.points) {
                gl.glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
            }
            gl.glEnd();
            gl.glDisable(32823);
        }
    }

    public void setAlphaFactor(float a) {
        this.alpha = a;
    }
}

