/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.canvas;

import com.jogamp.opengl.util.Animator;
import java.awt.image.BufferedImage;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.awt.GLCanvas;
import org.jzy3d.factories.JzyFactories;
import org.jzy3d.global.Settings;
import org.jzy3d.plot3d.rendering.canvas.IScreenCanvas;
import org.jzy3d.plot3d.rendering.canvas.Quality;
import org.jzy3d.plot3d.rendering.scene.Scene;
import org.jzy3d.plot3d.rendering.view.Renderer3d;
import org.jzy3d.plot3d.rendering.view.View;

public class CanvasAWT
extends GLCanvas
implements IScreenCanvas {
    protected View view;
    protected Renderer3d renderer;
    protected Animator animator;
    private static final long serialVersionUID = 980088854683562436L;

    public CanvasAWT(Scene scene, Quality quality) {
        this(scene, quality, (GLCapabilitiesImmutable)Settings.getInstance().getGLCapabilities());
    }

    public CanvasAWT(Scene scene, Quality quality, GLCapabilitiesImmutable glci) {
        this(scene, quality, glci, false, false);
    }

    public CanvasAWT(Scene scene, Quality quality, GLCapabilitiesImmutable glci, boolean traceGL, boolean debugGL) {
        super(glci);
        this.view = scene.newView(this, quality);
        this.renderer = JzyFactories.renderer3d.getInstance(this.view, traceGL, debugGL);
        this.addGLEventListener(this.renderer);
        this.setAutoSwapBufferMode(quality.isAutoSwapBuffer());
        if (quality.isAnimated()) {
            this.animator = new Animator((GLAutoDrawable)this);
            this.getAnimator().start();
        }
    }

    public void dispose() {
        new Thread(new Runnable(){

            public void run() {
                CanvasAWT.this.animator.stop();
                CanvasAWT.this.renderer = null;
                CanvasAWT.this.view = null;
            }
        }).start();
    }

    public void forceRepaint() {
        this.display();
    }

    public BufferedImage screenshot() {
        this.renderer.nextDisplayUpdateScreenshot();
        this.display();
        return this.renderer.getLastScreenshot();
    }

    public View getView() {
        return this.view;
    }

    public int getRendererWidth() {
        return this.renderer != null ? this.renderer.getWidth() : 0;
    }

    public int getRendererHeight() {
        return this.renderer != null ? this.renderer.getHeight() : 0;
    }
}

