/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.canvas;

import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLPbuffer;
import javax.media.opengl.GLProfile;
import org.jzy3d.factories.JzyFactories;
import org.jzy3d.global.Settings;
import org.jzy3d.plot3d.pipelines.NotImplementedException;
import org.jzy3d.plot3d.rendering.canvas.ICanvas;
import org.jzy3d.plot3d.rendering.canvas.Quality;
import org.jzy3d.plot3d.rendering.scene.Scene;
import org.jzy3d.plot3d.rendering.view.Renderer3d;
import org.jzy3d.plot3d.rendering.view.View;

public class OffscreenCanvas
implements ICanvas {
    protected View view;
    protected Renderer3d renderer;
    protected GLPbuffer glpBuffer;

    public OffscreenCanvas(Scene scene, Quality quality, GLProfile profile, int width, int height) {
        this.view = scene.newView(this, quality);
        this.renderer = JzyFactories.renderer3d.getInstance(this.view, false, false);
        this.initGLPBuffer(width, height);
    }

    protected void initGLPBuffer(int width, int height) {
        GLCapabilities caps = Settings.getInstance().getGLCapabilities();
        caps.setDoubleBuffered(false);
        if (!GLDrawableFactory.getFactory((GLProfile)caps.getGLProfile()).canCreateGLPbuffer(null)) {
            throw new RuntimeException("No pbuffer support");
        }
        this.glpBuffer = GLDrawableFactory.getFactory((GLProfile)caps.getGLProfile()).createGLPbuffer(null, (GLCapabilitiesImmutable)caps, null, width, height, null);
        this.glpBuffer.addGLEventListener((GLEventListener)this.renderer);
    }

    public GLPbuffer getGlpBuffer() {
        return this.glpBuffer;
    }

    public void dispose() {
        this.glpBuffer.destroy();
        this.renderer = null;
        this.view = null;
    }

    public void forceRepaint() {
        this.glpBuffer.display();
    }

    public BufferedImage screenshot() {
        this.renderer.nextDisplayUpdateScreenshot();
        this.glpBuffer.display();
        return this.renderer.getLastScreenshot();
    }

    public View getView() {
        return this.view;
    }

    public int getRendererWidth() {
        return this.renderer != null ? this.renderer.getWidth() : 0;
    }

    public int getRendererHeight() {
        return this.renderer != null ? this.renderer.getHeight() : 0;
    }

    public void removeKeyListener(KeyListener listener) {
        throw new NotImplementedException();
    }

    public void removeMouseListener(MouseListener listener) {
        throw new NotImplementedException();
    }

    public void removeMouseMotionListener(MouseMotionListener listener) {
        throw new NotImplementedException();
    }

    public void removeMouseWheelListener(MouseWheelListener listener) {
        throw new NotImplementedException();
    }

    public void addKeyListener(KeyListener listener) {
        throw new NotImplementedException();
    }

    public void addMouseListener(MouseListener listener) {
        throw new NotImplementedException();
    }

    public void addMouseMotionListener(MouseMotionListener listener) {
        throw new NotImplementedException();
    }

    public void addMouseWheelListener(MouseWheelListener listener) {
        throw new NotImplementedException();
    }
}

