/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.legends;

import java.awt.Image;
import java.io.IOException;
import org.jzy3d.events.DrawableChangedEvent;
import org.jzy3d.events.IDrawableListener;
import org.jzy3d.io.FileImage;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.rendering.view.ImageViewport;

public abstract class Legend
extends ImageViewport
implements IDrawableListener {
    protected AbstractDrawable parent;

    public Legend(AbstractDrawable parent) {
        this.parent = parent;
        if (parent != null) {
            parent.addDrawableListener(this);
        }
    }

    public void dispose() {
        if (this.parent != null) {
            this.parent.removeDrawableListener(this);
        }
    }

    public abstract Image toImage(int var1, int var2);

    public abstract void drawableChanged(DrawableChangedEvent var1);

    public void setViewPort(int width, int height, float left, float right) {
        super.setViewPort(width, height, left, right);
        int imgWidth = (int)((float)width * (right - left));
        if (this.imageWidth != imgWidth || this.imageHeight != height) {
            this.setImage(this.toImage(imgWidth, height));
        }
    }

    public void updateImage() {
        this.setImage(this.toImage(this.imageWidth, this.imageHeight));
    }

    public void saveImage() {
        try {
            FileImage.savePNG(this.imageObj, "data/colorbar.png");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

