/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.ordering;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.transform.Transform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrderingStrategy
implements Comparator<AbstractDrawable> {
    protected Camera camera;
    protected Transform transform;
    protected GL2 gl;
    protected GLU glu;

    public void sort(List<AbstractDrawable> monotypes, Camera cam) {
        this.setCamera(cam);
        Collections.sort(monotypes, this);
    }

    protected int comparison(double dist1, double dist2) {
        if (dist1 == dist2) {
            return 0;
        }
        if (dist1 < dist2) {
            return 1;
        }
        return -1;
    }

    public void setAll(GL2 gl, GLU glu, Camera camera, Transform transform) {
        this.gl = gl;
        this.glu = glu;
        this.camera = camera;
        this.transform = transform;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    public Transform getTransform() {
        return this.transform;
    }

    public void setTransform(Transform transform) {
        this.transform = transform;
    }

    public GL2 getGl() {
        return this.gl;
    }

    public void setGl(GL2 gl) {
        this.gl = gl;
    }

    public GLU getGlu() {
        return this.glu;
    }

    public void setGlu(GLU glu) {
        this.glu = glu;
    }
}

