/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.tooltips;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.IntegerCoord2d;
import org.jzy3d.plot3d.rendering.tooltips.ITooltipRenderer;

public class CoordinateTooltipRenderer
implements ITooltipRenderer {
    protected String xUnit;
    protected String yUnit;
    protected String zUnit;
    protected boolean renderX;
    protected boolean renderY;
    protected boolean renderZ;
    protected Coord3d target = Coord3d.INVALID;
    protected IntegerCoord2d screenLocation = new IntegerCoord2d();
    protected Rectangle lastBounds;
    protected boolean newLineAfterEachDim;

    public CoordinateTooltipRenderer() {
        this(null);
    }

    public CoordinateTooltipRenderer(IntegerCoord2d screen) {
        this("X", "Y", "Z", screen);
    }

    public CoordinateTooltipRenderer(IntegerCoord2d screen, Coord3d target) {
        this("X", "Y", "Z", screen);
        this.target = target;
    }

    public CoordinateTooltipRenderer(String xUnit, String yUnit, String zUnit) {
        this(xUnit, yUnit, zUnit, null);
    }

    public CoordinateTooltipRenderer(String xUnit, String yUnit, String zUnit, IntegerCoord2d screen) {
        this(xUnit, yUnit, zUnit, xUnit != null, yUnit != null, zUnit != null, screen, null);
    }

    public CoordinateTooltipRenderer(String xUnit, String yUnit, String zUnit, IntegerCoord2d screen, Coord3d target) {
        this(xUnit, yUnit, zUnit, xUnit != null, yUnit != null, zUnit != null, screen, target, false);
    }

    public CoordinateTooltipRenderer(String xUnit, String yUnit, String zUnit, IntegerCoord2d screen, Coord3d target, boolean newLineAfterEachDim) {
        this(xUnit, yUnit, zUnit, xUnit != null, yUnit != null, zUnit != null, screen, target, newLineAfterEachDim);
    }

    public CoordinateTooltipRenderer(String xUnit, String yUnit, String zUnit, boolean renderX, boolean renderY, boolean renderZ, IntegerCoord2d screen, Coord3d target) {
        this(xUnit, yUnit, zUnit, renderX, renderY, renderZ, screen, target, false);
    }

    public CoordinateTooltipRenderer(String xUnit, String yUnit, String zUnit, boolean renderX, boolean renderY, boolean renderZ, IntegerCoord2d screen, Coord3d target, boolean newLineAfterEachDim) {
        this.xUnit = xUnit;
        this.yUnit = yUnit;
        this.zUnit = zUnit;
        this.renderX = renderX;
        this.renderY = renderY;
        this.renderZ = renderZ;
        this.newLineAfterEachDim = newLineAfterEachDim;
        if (screen != null) {
            this.screenLocation = screen;
        }
        if (target != null) {
            this.target = target;
        }
    }

    public void render(Graphics2D g2d) {
        if (this.newLineAfterEachDim) {
            String xcontent = this.xUnit + " = " + this.target.x;
            String ycontent = this.yUnit + " = " + this.target.y;
            String zcontent = this.zUnit + " = " + this.target.z;
            int maxlength = Math.max(Math.max(xcontent.length(), ycontent.length()), zcontent.length());
            this.lastBounds = new Rectangle(this.screenLocation.x - 10, this.screenLocation.y - 13, 10 + maxlength * 6, 48);
            g2d.setColor(Color.WHITE);
            g2d.fillRect(this.lastBounds.x, this.lastBounds.y, this.lastBounds.width, this.lastBounds.height);
            g2d.setColor(Color.BLACK);
            g2d.drawRect(this.lastBounds.x, this.lastBounds.y, this.lastBounds.width, this.lastBounds.height);
            g2d.drawString(xcontent, this.screenLocation.x, this.screenLocation.y);
            g2d.drawString(ycontent, this.screenLocation.x, this.screenLocation.y + 16);
            g2d.drawString(zcontent, this.screenLocation.x, this.screenLocation.y + 32);
        } else {
            String content = this.format(this.target);
            this.lastBounds = new Rectangle(this.screenLocation.x - 10, this.screenLocation.y - 13, 10 + content.length() * 6, 16);
            g2d.setColor(Color.WHITE);
            g2d.fillRect(this.lastBounds.x, this.lastBounds.y, this.lastBounds.width, this.lastBounds.height);
            g2d.setColor(Color.BLACK);
            g2d.drawRect(this.lastBounds.x, this.lastBounds.y, this.lastBounds.width, this.lastBounds.height);
            g2d.drawString(content, this.screenLocation.x, this.screenLocation.y);
        }
    }

    public void updateScreenPosition(IntegerCoord2d position) {
        this.screenLocation = position;
    }

    public void updateTargetCoordinate(Coord3d target) {
        this.target = target;
    }

    public String format(Coord3d c) {
        String out = "";
        if (this.renderX) {
            out = out + this.xUnit + " = " + c.x + "  ";
        }
        if (this.renderY) {
            out = out + this.yUnit + " = " + c.y + "  ";
        }
        if (this.renderZ) {
            out = out + this.zUnit + " = " + c.z + "  ";
        }
        return out;
    }
}

