/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.view;

import java.awt.Dimension;
import java.awt.Image;
import java.nio.ByteBuffer;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.jzy3d.io.GLImage;
import org.jzy3d.plot3d.rendering.view.AbstractViewport;
import org.jzy3d.plot3d.rendering.view.ImageRenderer;

public class ImageViewport
extends AbstractViewport {
    private ByteBuffer imageData = null;
    protected Image imageObj;
    protected int imageHeight;
    protected int imageWidth;

    public ImageViewport() {
        this.setStretchToFill(false);
    }

    public void render(GL2 gl, GLU glu) {
        gl.glMatrixMode(5889);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        this.applyViewPort(gl, glu);
        gl.glOrtho(0.0, (double)this.screenWidth, 0.0, (double)this.screenHeight, -1.0, 1.0);
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        ImageRenderer.renderImage(gl, this.imageData, this.imageWidth, this.imageHeight, this.screenWidth, this.screenHeight, -0.75f);
        gl.glPopMatrix();
        gl.glMatrixMode(5889);
        gl.glPopMatrix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(Image image, int width, int height) {
        if (image != null) {
            Image image2 = image;
            synchronized (image2) {
                ByteBuffer b = GLImage.getImageAsGlByteBuffer(image, width, height);
                this.setImage(image, width, height, b);
            }
        }
    }

    public void setImage(Image image, int width, int height, ByteBuffer buffer) {
        this.imageObj = image;
        this.imageHeight = height;
        this.imageWidth = width;
        this.imageData = buffer;
    }

    public void setImage(Image image) {
        if (image != null) {
            this.setImage(image, image.getWidth(null), image.getHeight(null));
        }
    }

    public Image getImage() {
        return this.imageObj;
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public Dimension getPreferedSize() {
        return new Dimension(1, 1);
    }
}

