/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.view;

import com.jogamp.opengl.util.awt.Screenshot;
import java.awt.image.BufferedImage;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLPipelineFactory;
import javax.media.opengl.glu.GLU;
import org.jzy3d.plot3d.rendering.view.View;

public class Renderer3d
implements GLEventListener {
    protected GLU glu;
    protected View view;
    protected int width = 0;
    protected int height = 0;
    protected boolean doScreenshotAtNextDisplay = false;
    protected BufferedImage image = null;
    protected boolean traceGL = false;
    protected boolean debugGL = false;

    public Renderer3d(View view) {
        this(view, false, false);
    }

    public Renderer3d(View view, boolean traceGL, boolean debugGL) {
        this.view = view;
        this.traceGL = traceGL;
        this.debugGL = debugGL;
        this.glu = new GLU();
    }

    public void init(GLAutoDrawable canvas) {
        if (canvas != null && canvas.getGL() != null && canvas.getGL().getGL2() != null && this.view != null) {
            if (this.debugGL) {
                canvas.getGL().getContext().setGL(GLPipelineFactory.create((String)"javax.media.opengl.Debug", null, (GL)canvas.getGL(), null));
            }
            if (this.traceGL) {
                canvas.getGL().getContext().setGL(GLPipelineFactory.create((String)"javax.media.opengl.Trace", null, (GL)canvas.getGL(), (Object[])new Object[]{System.err}));
            }
            this.view.init(canvas.getGL().getGL2());
            if (this.view != null) {
                this.view.getScene().getGraph().mountAllGLBindedResources(canvas.getGL().getGL2());
                this.view.setBoundManual(this.view.getScene().getGraph().getBounds());
            }
        }
    }

    public void display(GLAutoDrawable canvas) {
        GL2 gl = canvas.getGL().getGL2();
        if (this.view != null) {
            this.view.clear(gl);
            this.view.render(gl, this.glu);
            if (this.doScreenshotAtNextDisplay) {
                this.image = Screenshot.readToBufferedImage((int)this.width, (int)this.height);
                this.doScreenshotAtNextDisplay = false;
            }
        }
    }

    public void reshape(GLAutoDrawable canvas, int x, int y, int width, int height) {
        this.width = width;
        this.height = height;
        if (this.view != null) {
            this.view.dimensionDirty = true;
            if (canvas != null) {
                GL2 gl = canvas.getGL().getGL2();
                this.view.clear(gl);
                this.view.render(gl, this.glu);
            }
        }
    }

    public void dispose(GLAutoDrawable arg0) {
        this.view = null;
        this.glu = null;
    }

    public void nextDisplayUpdateScreenshot() {
        this.doScreenshotAtNextDisplay = true;
    }

    public BufferedImage getLastScreenshot() {
        return this.image;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

