/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.view;

import com.jogamp.opengl.util.awt.Overlay;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.glu.GLU;
import org.jzy3d.events.IViewIsVerticalEventListener;
import org.jzy3d.events.IViewPointChangedListener;
import org.jzy3d.events.ViewIsVerticalEvent;
import org.jzy3d.events.ViewPointChangedEvent;
import org.jzy3d.factories.JzyFactories;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Scale;
import org.jzy3d.plot3d.primitives.Parallelepiped;
import org.jzy3d.plot3d.primitives.axes.AxeBox;
import org.jzy3d.plot3d.primitives.axes.IAxe;
import org.jzy3d.plot3d.rendering.canvas.CanvasAWT;
import org.jzy3d.plot3d.rendering.canvas.CanvasSwing;
import org.jzy3d.plot3d.rendering.canvas.ICanvas;
import org.jzy3d.plot3d.rendering.canvas.OffscreenCanvas;
import org.jzy3d.plot3d.rendering.canvas.Quality;
import org.jzy3d.plot3d.rendering.scene.Scene;
import org.jzy3d.plot3d.rendering.tooltips.ITooltipRenderer;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.rendering.view.ImageViewport;
import org.jzy3d.plot3d.rendering.view.Renderer2d;
import org.jzy3d.plot3d.rendering.view.ViewPort;
import org.jzy3d.plot3d.rendering.view.modes.CameraMode;
import org.jzy3d.plot3d.rendering.view.modes.ViewBoundMode;
import org.jzy3d.plot3d.rendering.view.modes.ViewPositionMode;
import org.jzy3d.plot3d.transform.Transform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class View {
    protected GLU glu;
    public static float STRETCH_RATIO = 0.25f;
    protected boolean MAINTAIN_ALL_OBJECTS_IN_VIEW = false;
    protected boolean DISPLAY_AXE_WHOLE_BOUNDS = false;
    protected boolean axeBoxDisplayed = true;
    protected boolean squared = true;
    protected Camera cam;
    protected IAxe axe;
    protected Quality quality;
    protected Overlay overlay;
    protected Scene scene;
    protected ICanvas canvas;
    protected Coord3d viewpoint;
    protected Coord3d center;
    protected Coord3d scaling;
    protected BoundingBox3d viewbounds;
    protected CameraMode cameraMode;
    protected ViewPositionMode viewmode;
    protected ViewBoundMode boundmode;
    protected ImageViewport bgViewport;
    protected BufferedImage bgImg = null;
    protected BoundingBox3d targetBox;
    protected org.jzy3d.colors.Color bgColor = org.jzy3d.colors.Color.BLACK;
    protected Color bgOverlay = new Color(0, 0, 0, 0);
    protected List<ITooltipRenderer> tooltips;
    protected List<Renderer2d> renderers;
    protected List<IViewPointChangedListener> viewPointChangedListeners;
    protected List<IViewIsVerticalEventListener> viewOnTopListeners;
    protected boolean wasOnTopAtLastRendering;
    protected static final float PI_div2 = 1.5707964f;
    public static final Coord3d DEFAULT_VIEW = new Coord3d(1.0471975511965976, 1.0471975511965976, 2000.0);
    protected boolean dimensionDirty = false;
    protected boolean viewDirty = false;
    protected static View current;

    public View(Scene scene, ICanvas canvas, Quality quality) {
        BoundingBox3d sceneBounds = scene.getGraph().getBounds();
        this.viewpoint = DEFAULT_VIEW.clone();
        this.center = sceneBounds.getCenter();
        this.scaling = Coord3d.IDENTITY.clone();
        this.viewmode = ViewPositionMode.FREE;
        this.boundmode = ViewBoundMode.AUTO_FIT;
        this.cameraMode = CameraMode.ORTHOGONAL;
        this.axe = JzyFactories.axe.getInstance(sceneBounds, this);
        this.cam = JzyFactories.camera.getInstance(this.center);
        this.scene = scene;
        this.canvas = canvas;
        this.quality = quality;
        this.renderers = new ArrayList<Renderer2d>(1);
        this.tooltips = new ArrayList<ITooltipRenderer>();
        this.bgViewport = new ImageViewport();
        this.viewOnTopListeners = new ArrayList<IViewIsVerticalEventListener>();
        this.viewPointChangedListeners = new ArrayList<IViewPointChangedListener>();
        this.wasOnTopAtLastRendering = false;
        if (canvas instanceof CanvasSwing) {
            this.overlay = new Overlay((GLDrawable)((CanvasSwing)canvas));
        } else if (canvas instanceof CanvasAWT) {
            this.overlay = new Overlay((GLDrawable)((CanvasAWT)canvas));
        } else if (canvas instanceof OffscreenCanvas) {
            this.overlay = new Overlay((GLDrawable)((OffscreenCanvas)canvas).getGlpBuffer());
        } else {
            throw new RuntimeException("unhandled canvas! " + canvas);
        }
        this.glu = new GLU();
        current = this;
    }

    public void dispose() {
        this.axe.dispose();
        this.cam = null;
        this.renderers.clear();
        this.viewOnTopListeners.clear();
        this.scene = null;
        this.canvas = null;
        this.quality = null;
    }

    public void shoot() {
        this.canvas.forceRepaint();
    }

    public void project() {
        GL2 gl = this.getCurrentGL();
        this.scene.getGraph().project(gl, this.glu, this.cam);
        this.getCurrentContext().release();
    }

    public Coord3d projectMouse(int x, int y) {
        GL2 gl = this.getCurrentGL();
        Coord3d p = this.cam.screenToModel(gl, this.glu, new Coord3d(x, y, 0.0f));
        this.getCurrentContext().release();
        return p;
    }

    public void rotate(Coord2d move) {
        this.rotate(move, true);
    }

    public void rotate(Coord2d move, boolean updateView) {
        Coord3d eye = this.getViewPoint();
        eye.x -= move.x;
        eye.y += move.y;
        this.setViewPoint(eye, updateView);
    }

    public void shift(float factor) {
        this.shift(factor, true);
    }

    public void shift(float factor, boolean updateView) {
        Scale current = this.getScale();
        Scale newScale = current.add((double)factor * current.getRange());
        this.setScale(newScale, updateView);
    }

    public void zoom(float factor) {
        this.zoom(factor, true);
    }

    public void zoom(float factor, boolean updateView) {
        Scale current = this.getScale();
        double range = current.getMax() - current.getMin();
        if (range <= 0.0) {
            return;
        }
        double center = (current.getMax() + current.getMin()) / 2.0;
        double zmin = center + (current.getMin() - center) * (double)factor;
        double zmax = center + (current.getMax() - center) * (double)factor;
        Scale scale = null;
        if (zmin < zmax) {
            scale = new Scale(zmin, zmax);
        } else if (factor < 1.0f) {
            scale = new Scale(center, center);
        }
        if (scale != null) {
            this.setScale(scale, updateView);
        }
    }

    public void zoomX(float factor) {
        this.zoomX(factor, true);
    }

    public void zoomX(float factor, boolean updateView) {
        double range = this.getBounds().getXmax() - this.getBounds().getXmin();
        if (range <= 0.0) {
            return;
        }
        double center = (this.getBounds().getXmax() + this.getBounds().getXmin()) / 2.0f;
        double min = center + ((double)this.getBounds().getXmin() - center) * (double)factor;
        double max = center + ((double)this.getBounds().getXmax() - center) * (double)factor;
        Scale scale = null;
        if (min < max) {
            scale = new Scale(min, max);
        } else if (factor < 1.0f) {
            scale = new Scale(center, center);
        }
        if (scale != null) {
            BoundingBox3d bounds = this.getBounds();
            bounds.setXmin((float)scale.getMin());
            bounds.setXmax((float)scale.getMax());
            this.setBoundManual(bounds);
            if (updateView) {
                this.shoot();
            }
        }
    }

    public void zoomY(float factor) {
        this.zoomY(factor, true);
    }

    public void zoomY(float factor, boolean updateView) {
        double range = this.getBounds().getYmax() - this.getBounds().getYmin();
        if (range <= 0.0) {
            return;
        }
        double center = (this.getBounds().getYmax() + this.getBounds().getYmin()) / 2.0f;
        double min = center + ((double)this.getBounds().getYmin() - center) * (double)factor;
        double max = center + ((double)this.getBounds().getYmax() - center) * (double)factor;
        Scale scale = null;
        if (min < max) {
            scale = new Scale(min, max);
        } else if (factor < 1.0f) {
            scale = new Scale(center, center);
        }
        if (scale != null) {
            BoundingBox3d bounds = this.getBounds();
            bounds.setYmin((float)scale.getMin());
            bounds.setYmax((float)scale.getMax());
            this.setBoundManual(bounds);
            if (updateView) {
                this.shoot();
            }
        }
    }

    public void zoomZ(float factor) {
        this.zoomZ(factor, true);
    }

    public void zoomZ(float factor, boolean updateView) {
        double range = this.getBounds().getZmax() - this.getBounds().getZmin();
        if (range <= 0.0) {
            return;
        }
        double center = (this.getBounds().getZmax() + this.getBounds().getZmin()) / 2.0f;
        double min = center + ((double)this.getBounds().getZmin() - center) * (double)factor;
        double max = center + ((double)this.getBounds().getZmax() - center) * (double)factor;
        Scale scale = null;
        if (min < max) {
            scale = new Scale(min, max);
        } else if (factor < 1.0f) {
            scale = new Scale(center, center);
        }
        if (scale != null) {
            BoundingBox3d bounds = this.getBounds();
            bounds.setZmin((float)scale.getMin());
            bounds.setZmax((float)scale.getMax());
            this.setBoundManual(bounds);
            if (updateView) {
                this.shoot();
            }
        }
    }

    public void setScale(Scale scale) {
        this.setScale(scale, true);
    }

    public void setScale(Scale scale, boolean notify) {
        BoundingBox3d bounds = this.getBounds();
        bounds.setZmin((float)scale.getMin());
        bounds.setZmax((float)scale.getMax());
        this.setBoundManual(bounds);
        if (notify) {
            this.shoot();
        }
    }

    public Scale getScale() {
        return new Scale(this.getBounds().getZmin(), this.getBounds().getZmax());
    }

    public void lookToBox(BoundingBox3d box) {
        this.center = box.getCenter();
        this.axe.setAxe(box);
        this.targetBox = box;
    }

    public BoundingBox3d getBounds() {
        return this.axe.getBoxBounds();
    }

    public ViewBoundMode getBoundsMode() {
        return this.boundmode;
    }

    public void setViewPositionMode(ViewPositionMode mode) {
        this.viewmode = mode;
    }

    public ViewPositionMode getViewMode() {
        return this.viewmode;
    }

    public void setViewPoint(Coord3d polar, boolean updateView) {
        this.viewpoint = polar;
        this.viewpoint.y = this.viewpoint.y < -1.5707964f ? -1.5707964f : this.viewpoint.y;
        float f = this.viewpoint.y = this.viewpoint.y > 1.5707964f ? 1.5707964f : this.viewpoint.y;
        if (updateView) {
            this.shoot();
        }
        this.fireViewPointChangedEvent(new ViewPointChangedEvent(this, polar));
    }

    public void setViewPoint(Coord3d polar) {
        this.setViewPoint(polar, true);
    }

    public Coord3d getViewPoint() {
        return this.viewpoint;
    }

    public Coord3d getLastViewScaling() {
        return this.scaling;
    }

    public void setAxe(AxeBox ax) {
        this.axe = ax;
        this.updateBounds();
    }

    public IAxe getAxe() {
        return this.axe;
    }

    public boolean getSquared() {
        return this.squared;
    }

    public void setSquared(boolean status) {
        this.squared = status;
    }

    public boolean isAxeBoxDisplayed() {
        return this.axeBoxDisplayed;
    }

    public void setAxeBoxDisplayed(boolean axeBoxDisplayed) {
        this.axeBoxDisplayed = axeBoxDisplayed;
    }

    public void setBackgroundColor(org.jzy3d.colors.Color color) {
        this.bgColor = color;
    }

    public org.jzy3d.colors.Color getBackgroundColor() {
        return this.bgColor;
    }

    public void setBackgroundImage(BufferedImage i) {
        this.bgImg = i;
        this.bgViewport.setImage(this.bgImg, this.bgImg.getWidth(), this.bgImg.getHeight());
        this.bgViewport.setStretchToFill(true);
    }

    public BufferedImage getBackgroundImage() {
        return this.bgImg;
    }

    public Camera getCamera() {
        return this.cam;
    }

    public void setCameraMode(CameraMode mode) {
        this.cameraMode = mode;
    }

    public CameraMode getCameraMode() {
        return this.cameraMode;
    }

    public void getMaximized() {
        this.cam.getStretchToFill();
    }

    public void setMaximized(boolean status) {
        this.cam.setStretchToFill(status);
    }

    public Scene getScene() {
        return this.scene;
    }

    public Rectangle getSceneViewportRectangle() {
        return this.cam.getRectangle();
    }

    public void clearTooltips() {
        this.tooltips.clear();
    }

    public void setTooltip(ITooltipRenderer tooltip) {
        this.tooltips.clear();
        this.tooltips.add(tooltip);
    }

    public void addTooltip(ITooltipRenderer tooltip) {
        this.tooltips.add(tooltip);
    }

    public void setTooltips(List<ITooltipRenderer> tooltip) {
        this.tooltips.clear();
        this.tooltips.addAll(tooltip);
    }

    public void addTooltips(List<ITooltipRenderer> tooltip) {
        this.tooltips.addAll(tooltip);
    }

    public List<ITooltipRenderer> getTooltips() {
        return this.tooltips;
    }

    public ICanvas getCanvas() {
        return this.canvas;
    }

    public void addRenderer2d(Renderer2d renderer) {
        this.renderers.add(renderer);
    }

    public void removeRenderer2d(Renderer2d renderer) {
        this.renderers.remove(renderer);
    }

    public boolean addViewOnTopEventListener(IViewIsVerticalEventListener listener) {
        return this.viewOnTopListeners.add(listener);
    }

    public boolean removeViewOnTopEventListener(IViewIsVerticalEventListener listener) {
        return this.viewOnTopListeners.remove(listener);
    }

    protected void fireViewOnTopEvent(boolean isOnTop) {
        ViewIsVerticalEvent e = new ViewIsVerticalEvent(this);
        if (isOnTop) {
            for (IViewIsVerticalEventListener listener : this.viewOnTopListeners) {
                listener.viewVerticalReached(e);
            }
        } else {
            for (IViewIsVerticalEventListener listener : this.viewOnTopListeners) {
                listener.viewVerticalLeft(e);
            }
        }
    }

    public boolean addViewPointChangedListener(IViewPointChangedListener listener) {
        return this.viewPointChangedListeners.add(listener);
    }

    public boolean removeViewPointChangedListener(IViewPointChangedListener listener) {
        return this.viewPointChangedListeners.remove(listener);
    }

    protected void fireViewPointChangedEvent(ViewPointChangedEvent e) {
        for (IViewPointChangedListener vp : this.viewPointChangedListeners) {
            vp.viewPointChanged(e);
        }
    }

    public void setBoundMode(ViewBoundMode mode) {
        this.boundmode = mode;
        this.updateBounds();
    }

    public void updateBounds() {
        if (this.boundmode == ViewBoundMode.AUTO_FIT) {
            this.lookToBox(this.scene.getGraph().getBounds());
        } else if (this.boundmode == ViewBoundMode.MANUAL) {
            this.lookToBox(this.viewbounds);
        } else {
            throw new RuntimeException("Unknown bounds");
        }
        this.shoot();
    }

    public void updateBoundsForceUpdate(boolean refresh) {
        this.lookToBox(this.scene.getGraph().getBounds());
        if (refresh) {
            this.shoot();
        }
    }

    public void setBoundManual(BoundingBox3d bounds) {
        this.viewbounds = bounds;
        this.boundmode = ViewBoundMode.MANUAL;
        this.lookToBox(this.viewbounds);
    }

    protected Coord3d squarify() {
        BoundingBox3d bounds;
        if (this.boundmode == ViewBoundMode.AUTO_FIT) {
            bounds = this.scene.getGraph().getBounds();
        } else if (this.boundmode == ViewBoundMode.MANUAL) {
            bounds = this.viewbounds;
        } else {
            throw new RuntimeException("Unknown bounds");
        }
        float xLen = bounds.getXmax() - bounds.getXmin();
        float yLen = bounds.getYmax() - bounds.getYmin();
        float zLen = bounds.getZmax() - bounds.getZmin();
        float lmax = Math.max(Math.max(xLen, yLen), zLen);
        if (Float.isInfinite(xLen) || Float.isNaN(xLen) || xLen == 0.0f) {
            xLen = 1.0f;
        }
        if (Float.isInfinite(yLen) || Float.isNaN(yLen) || yLen == 0.0f) {
            yLen = 1.0f;
        }
        if (Float.isInfinite(zLen) || Float.isNaN(zLen) || zLen == 0.0f) {
            zLen = 1.0f;
        }
        if (Float.isInfinite(lmax) || Float.isNaN(lmax) || lmax == 0.0f) {
            lmax = 1.0f;
        }
        return new Coord3d(lmax / xLen, lmax / yLen, lmax / zLen);
    }

    public GL2 getCurrentGL() {
        this.getCurrentContext().makeCurrent();
        return this.getCanvasAsGLAutoDrawable().getGL().getGL2();
    }

    public GLContext getCurrentContext() {
        GLAutoDrawable c = this.getCanvasAsGLAutoDrawable();
        GLContext context = c.getContext();
        return context;
    }

    protected GLAutoDrawable getCanvasAsGLAutoDrawable() {
        if (this.canvas instanceof GLAutoDrawable) {
            GLAutoDrawable c = (GLAutoDrawable)this.canvas;
            return (GLAutoDrawable)this.canvas;
        }
        throw new RuntimeException("Unexpected instance type");
    }

    public void init(GL2 gl) {
        this.initQuality(gl);
        this.initLights(gl);
    }

    public void initQuality(GL2 gl) {
        if (this.quality.isDepthActivated()) {
            gl.glEnable(2929);
            gl.glDepthFunc(515);
        } else {
            gl.glDisable(2929);
        }
        gl.glBlendFunc(770, 771);
        if (this.quality.isAlphaActivated()) {
            gl.glEnable(3008);
            if (this.quality.isDisableDepthBufferWhenAlpha()) {
                gl.glDisable(2929);
            }
        } else {
            gl.glDisable(3008);
        }
        if (this.quality.isSmoothColor()) {
            gl.glShadeModel(7425);
        } else {
            gl.glShadeModel(7424);
        }
        if (this.quality.isSmoothPolygon()) {
            gl.glEnable(2881);
            gl.glHint(3155, 4353);
        } else {
            gl.glDisable(2881);
        }
        if (this.quality.isSmoothLine()) {
            gl.glEnable(2848);
            gl.glHint(3154, 4353);
        } else {
            gl.glDisable(2848);
        }
        if (this.quality.isSmoothPoint()) {
            gl.glEnable(2832);
            gl.glHint(3153, 4353);
        } else {
            gl.glDisable(2832);
        }
    }

    public void initLights(GL2 gl) {
        this.scene.getLightSet().init(gl);
        this.scene.getLightSet().enableLightIfThereAreLights(gl);
    }

    public void clear(GL2 gl) {
        this.clearColorAndDepth(gl);
    }

    public void clearColorAndDepth(GL2 gl) {
        gl.glClearColor(this.bgColor.r, this.bgColor.g, this.bgColor.b, this.bgColor.a);
        gl.glClearDepth(1.0);
        gl.glClear(16640);
    }

    public void render(GL2 gl, GLU glu) {
        this.renderBackground(gl, glu, 0.0f, 1.0f);
        this.renderScene(gl, glu);
        this.renderOverlay(gl);
        if (this.dimensionDirty) {
            this.dimensionDirty = false;
        }
    }

    public void renderBackground(GL2 gl, GLU glu, float left, float right) {
        if (this.bgImg != null) {
            this.bgViewport.setViewPort(this.canvas.getRendererWidth(), this.canvas.getRendererHeight(), left, right);
            this.bgViewport.render(gl, glu);
        }
    }

    public void renderBackground(GL2 gl, GLU glu, ViewPort viewport) {
        if (this.bgImg != null) {
            this.bgViewport.setViewPort(viewport);
            this.bgViewport.render(gl, glu);
        }
    }

    public void renderScene(GL2 gl, GLU glu) {
        this.renderScene(gl, glu, new ViewPort(this.canvas.getRendererWidth(), this.canvas.getRendererHeight()));
    }

    public void renderScene(GL2 gl, GLU glu, float left, float right) {
        this.renderScene(gl, glu, ViewPort.slice(this.canvas.getRendererWidth(), this.canvas.getRendererHeight(), left, right));
    }

    public void renderScene(GL2 gl, GLU glu, ViewPort viewport) {
        this.updateQuality(gl);
        this.updateCamera(gl, glu, viewport, this.computeScaling());
        this.renderAxeBox(gl, glu);
        this.renderSceneGraph(gl, glu);
    }

    public void updateQuality(GL2 gl) {
        if (this.quality.isAlphaActivated()) {
            gl.glEnable(3042);
        } else {
            gl.glDisable(3042);
        }
    }

    public BoundingBox3d computeScaling() {
        this.scaling = this.squared ? this.squarify() : Coord3d.IDENTITY.clone();
        if (this.targetBox == null) {
            this.targetBox = new BoundingBox3d(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f);
        }
        BoundingBox3d boundsScaled = new BoundingBox3d();
        boundsScaled.add(this.targetBox.scale(this.scaling));
        if (this.MAINTAIN_ALL_OBJECTS_IN_VIEW) {
            boundsScaled.add(this.scene.getGraph().getBounds().scale(this.scaling));
        }
        return boundsScaled;
    }

    public void updateCamera(GL2 gl, GLU glu, ViewPort viewport, BoundingBox3d boundsScaled) {
        this.updateCamera(gl, glu, viewport, boundsScaled, (float)boundsScaled.getRadius());
    }

    public void updateCamera(GL2 gl, GLU glu, ViewPort viewport, BoundingBox3d boundsScaled, float sceneRadiusScaled) {
        Coord3d up;
        Coord3d eye;
        Coord3d target = this.center.mul(this.scaling);
        this.viewpoint.z = sceneRadiusScaled * 2.0f;
        if (this.viewmode == ViewPositionMode.FREE) {
            eye = this.viewpoint.cartesian().add(target);
        } else if (this.viewmode == ViewPositionMode.TOP) {
            eye = this.viewpoint;
            eye.x = -1.5707964f;
            eye.y = 1.5707964f;
            eye = eye.cartesian().add(target);
        } else if (this.viewmode == ViewPositionMode.PROFILE) {
            eye = this.viewpoint;
            eye.y = 0.0f;
            eye = eye.cartesian().add(target);
        } else {
            throw new RuntimeException("Unsupported ViewMode: " + (Object)((Object)this.viewmode));
        }
        if (Math.abs(this.viewpoint.y) == 1.5707964f) {
            Coord2d direction = new Coord2d(this.viewpoint.x, this.viewpoint.z).cartesian();
            up = this.viewpoint.y > 0.0f ? new Coord3d(-direction.x, -direction.y, 0.0f) : new Coord3d(direction.x, direction.y, 0.0f);
            if (!this.wasOnTopAtLastRendering) {
                this.wasOnTopAtLastRendering = true;
                this.fireViewOnTopEvent(true);
            }
        } else {
            up = new Coord3d(0.0f, 0.0f, 1.0f);
            if (this.wasOnTopAtLastRendering) {
                this.wasOnTopAtLastRendering = false;
                this.fireViewOnTopEvent(false);
            }
        }
        this.cam.setTarget(target);
        this.cam.setUp(up);
        this.cam.setEye(eye);
        if (this.viewmode == ViewPositionMode.TOP) {
            this.cam.setRenderingSphereRadius(Math.max(boundsScaled.getXmax() - boundsScaled.getXmin(), boundsScaled.getYmax() - boundsScaled.getYmin()) / 2.0f);
            this.correctCameraPositionForIncludingTextLabels(gl, glu, viewport);
        } else {
            this.cam.setRenderingSphereRadius(sceneRadiusScaled);
        }
        this.cam.setViewPort(viewport);
        this.cam.shoot(gl, glu, this.cameraMode);
    }

    public void renderAxeBox(GL2 gl, GLU glu) {
        if (this.axeBoxDisplayed) {
            gl.glMatrixMode(5888);
            this.scene.getLightSet().disable(gl);
            this.axe.setScale(this.scaling);
            this.axe.draw(gl, glu, this.cam);
            if (this.DISPLAY_AXE_WHOLE_BOUNDS) {
                AxeBox abox = (AxeBox)this.axe;
                BoundingBox3d box = abox.getWholeBounds();
                Parallelepiped p = new Parallelepiped(box);
                p.setFaceDisplayed(false);
                p.setWireframeColor(org.jzy3d.colors.Color.MAGENTA);
                p.setWireframeDisplayed(true);
                p.draw(gl, glu, this.cam);
            }
            this.scene.getLightSet().enableLightIfThereAreLights(gl);
        }
    }

    public void renderSceneGraph(GL2 gl, GLU glu) {
        this.renderSceneGraph(gl, glu, true);
    }

    public void renderSceneGraph(GL2 gl, GLU glu, boolean light) {
        if (light) {
            this.scene.getLightSet().apply(gl, this.scaling);
        }
        Transform transform = new Transform(new org.jzy3d.plot3d.transform.Scale(this.scaling));
        this.scene.getGraph().setTransform(transform);
        this.scene.getGraph().draw(gl, glu, this.cam);
    }

    public void renderOverlay(GL2 gl) {
        this.renderOverlay(gl, new ViewPort(0, 0, this.canvas.getRendererWidth(), this.canvas.getRendererHeight()));
    }

    public void renderOverlay(GL2 gl, ViewPort viewport) {
        gl.glPolygonMode(1032, 6914);
        gl.glViewport(viewport.x, viewport.y, viewport.width, viewport.height);
        if (this.overlay != null && viewport.width > 0 && viewport.height > 0) {
            Graphics2D g2d = this.overlay.createGraphics();
            g2d.setBackground(this.bgOverlay);
            g2d.clearRect(0, 0, this.canvas.getRendererWidth(), this.canvas.getRendererHeight());
            for (ITooltipRenderer t : this.tooltips) {
                t.render(g2d);
            }
            for (Renderer2d renderer : this.renderers) {
                renderer.paint(g2d);
            }
            this.overlay.markDirty(0, 0, this.canvas.getRendererWidth(), this.canvas.getRendererHeight());
            this.overlay.drawAll();
            g2d.dispose();
        }
    }

    protected void correctCameraPositionForIncludingTextLabels(GL2 gl, GLU glu, ViewPort viewport) {
        this.cam.setViewPort(viewport);
        this.cam.shoot(gl, glu, this.cameraMode);
        this.axe.draw(gl, glu, this.cam);
        this.clear(gl);
        AxeBox abox = (AxeBox)this.axe;
        BoundingBox3d newBounds = abox.getWholeBounds().scale(this.scaling);
        if (this.viewmode == ViewPositionMode.TOP) {
            float radius = Math.max(newBounds.getXmax() - newBounds.getXmin(), newBounds.getYmax() - newBounds.getYmin()) / 2.0f;
            radius += radius * STRETCH_RATIO;
            this.cam.setRenderingSphereRadius(radius);
        } else {
            this.cam.setRenderingSphereRadius((float)newBounds.getRadius());
        }
        Coord3d target = newBounds.getCenter();
        Coord3d eye = this.viewpoint.cartesian().add(target);
        this.cam.setTarget(target);
        this.cam.setEye(eye);
    }

    public static View current() {
        return current;
    }
}

