/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.text.overlay;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.rendering.canvas.CanvasAWT;
import org.jzy3d.plot3d.rendering.canvas.CanvasSwing;
import org.jzy3d.plot3d.rendering.canvas.ICanvas;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.rendering.view.Renderer2d;
import org.jzy3d.plot3d.text.align.Halign;
import org.jzy3d.plot3d.text.align.Valign;

public class TextOverlay
implements Renderer2d {
    private int targetWidth;
    private int targetHeight;
    private Component target;
    private List<TextDescriptor> textList;
    private ComponentListener resizeListener = new ComponentListener(){

        public void componentHidden(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
            Component obj = (Component)e.getSource();
            TextOverlay.this.targetWidth = obj.getWidth();
            TextOverlay.this.targetHeight = obj.getHeight();
        }

        public void componentShown(ComponentEvent e) {
        }
    };

    public TextOverlay(ICanvas canvas) {
        if (canvas instanceof CanvasAWT) {
            this.initComponent((Component)((Object)canvas));
        } else if (canvas instanceof CanvasSwing) {
            this.initComponent((Component)((Object)canvas));
        } else {
            throw new RuntimeException("TextRenderer not implemented for this Canvas implementation");
        }
    }

    private void initComponent(Component c) {
        this.textList = new ArrayList<TextDescriptor>(50);
        this.target = c;
        this.target.addComponentListener(this.resizeListener);
        this.targetWidth = this.target.getWidth();
        this.targetHeight = this.target.getHeight();
    }

    public void dispose() {
        this.target.removeComponentListener(this.resizeListener);
    }

    public void appendText(GL2 gl, GLU glu, Camera cam, String s, Coord3d position, Halign halign, Valign valign, org.jzy3d.colors.Color color) {
        Coord3d posScreen = cam.modelToScreen(gl, glu, position);
        this.textList.add(new TextDescriptor(s, new Coord2d(posScreen.x, posScreen.y), color, halign, valign));
    }

    public void paint(Graphics g) {
        FontMetrics metric = g.getFontMetrics();
        for (TextDescriptor t : this.textList) {
            int x = (int)t.position.x;
            int y = this.targetHeight - (int)t.position.y;
            Rectangle2D area = metric.getStringBounds(t.str, g);
            if (t.halign != Halign.RIGHT) {
                if (t.halign == Halign.CENTER) {
                    x -= (int)area.getWidth() / 2;
                } else if (t.halign == Halign.LEFT) {
                    x -= (int)area.getWidth();
                }
            }
            if (t.valign != Valign.TOP) {
                if (t.valign == Valign.CENTER) {
                    y += (int)area.getHeight() / 2;
                } else if (t.valign == Valign.BOTTOM || t.valign == Valign.GROUND) {
                    y += (int)area.getHeight();
                }
            }
            g.setColor(new Color(t.color.r, t.color.g, t.color.b, t.color.a));
            g.drawString(t.str, x, y);
        }
        this.textList.clear();
    }

    private class TextDescriptor {
        public String str;
        public org.jzy3d.colors.Color color;
        public Coord2d position;
        public Halign halign;
        public Valign valign;

        public TextDescriptor(String str, Coord2d position, org.jzy3d.colors.Color color, Halign halign, Valign valign) {
            this.str = str;
            this.position = position;
            this.color = color;
            this.halign = halign;
            this.valign = valign;
        }
    }
}

