/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.seisserv;

import edu.geophys.commons.model.SNS;
import edu.geophys.commons.model.Site;
import edu.geophys.commons.model.headerfiles.HeaderDatabase;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.commons.ui.FramePositionHelper;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.PlatformUtil;
import edu.geophys.commons.util.ProjectDirectories;
import edu.geophys.seisserv.SeisServConfiguration;
import edu.geophys.seisserv.swing.DTPServerWindow;
import edu.geophys.seisserv.swing.JTabbedDataLoader;
import edu.geophys.seisserv.swing.Tools;
import edu.geophys.seisserv.swing.knowledgebase.JKnowledgebaseEditor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.JFrame;

public class SeisServApplication {
    private Tools tools = new Tools();
    private JTabbedDataLoader chooser;
    private static final int jettyPort = 5555;
    private DTPServerWindow mainFrame;
    private HeaderDatabase headerDatabase = new HeaderDatabase();
    private File headerFile;
    private SeisServConfiguration config = new SeisServConfiguration();
    private final AbstractAction loadHeaderAction = new Action("Load Data", "Load data.", false){
        private static final long serialVersionUID = 4254486165750258439L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SeisServApplication.this.chooser = new JTabbedDataLoader(SeisServApplication.this.getMainFrame(), SeisServApplication.this.config);
            SeisServApplication.this.chooser.pack();
            SeisServApplication.this.chooser.setModal(true);
            SeisServApplication.this.chooser.setLocationRelativeTo(SeisServApplication.this.getMainFrame());
            SeisServApplication.this.chooser.setVisible(true);
            if (SeisServApplication.this.chooser.isLoad()) {
                switch (SeisServApplication.this.config.getDataSource()) {
                    case HEADER: {
                        SeisServApplication.this.unloadHeader();
                        SeisServApplication.this.dataState();
                        SeisServApplication.this.loadHeader(SeisServApplication.this.chooser.getHeaderFile());
                        break;
                    }
                }
                SeisServApplication.this.config.store();
                SeisServApplication.this.dataState();
            }
        }
    };
    private final AbstractAction unloadHeaderAction = new Action("Unload Header", "Unload current header", false){
        private static final long serialVersionUID = 2163385484705957800L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SeisServApplication.this.unloadHeader();
            SeisServApplication.this.dataState();
        }
    };
    private final AbstractAction editKnowledgeAction = new Action("Knowledgebase", "Start the Knowledgebase editor", false){
        private static final long serialVersionUID = -1951898978124678678L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JKnowledgebaseEditor jKnowledgebaseEditor = new JKnowledgebaseEditor((Frame)SeisServApplication.this.getMainFrame(), true);
            jKnowledgebaseEditor.setVisible(true);
            if (jKnowledgebaseEditor.isChanged()) {
                SeisServApplication.this.dataState();
            }
        }
    };

    private void unloadHeader() {
        this.showRelatedFrames(false);
        this.headerDatabase = new HeaderDatabase();
        SuiteManager.INSTANCE.setCurrentData(null, this.headerDatabase);
        this.getMainFrame().setHeaderFile(null);
        this.config.setLastOpenedHeader(null);
        Object[] objectArray = this.headerDatabase.listTraces();
        Arrays.sort(objectArray);
        SuiteManager.INSTANCE.getErrorConsoleUtil().getTextArea().setText("");
    }

    public HeaderDatabase getModel() {
        return this.headerDatabase;
    }

    public SeisServApplication(String[] stringArray) {
        File file;
        int n;
        Object object;
        String string;
        this.config.load();
        if (this.config.isDebugMode() || new File(PlatformUtil.getUserHome() + "/.nssdebug").exists()) {
            LogUtil.setToDebugLevel();
        }
        boolean bl = false;
        if (stringArray != null && stringArray.length == 1 && ((string = ((String)(object = stringArray[0].trim())).substring(n = ((String)object).lastIndexOf("."))).equalsIgnoreCase(".sht") || string.equalsIgnoreCase(".css") || string.equalsIgnoreCase(".c30") || string.equalsIgnoreCase(".c28")) && (file = new File((String)object)).isFile() && file.exists()) {
            this.loadHeader(file);
            bl = true;
        }
        if (!bl && this.config.isLastHeaderAutoload() && this.config.getLastOpenedHeader().exists()) {
            object = this.config.getLastOpenedHeader();
            this.loadHeader((File)object);
        }
        this.dataState();
    }

    private void dataState() {
        if (this.headerDatabase.sizeHeaders() < 1) {
            this.loadHeaderAction.setEnabled(true);
            this.unloadHeaderAction.setEnabled(false);
            this.editKnowledgeAction.setEnabled(false);
            this.showRelatedFrames(false);
            if (this.mainFrame != null) {
                this.mainFrame.updateSnsSelector();
                this.mainFrame.updateResamplingMode();
            }
        } else {
            this.checkForMissingHeaderEntries();
            this.loadHeaderAction.setEnabled(true);
            this.unloadHeaderAction.setEnabled(true);
            this.editKnowledgeAction.setEnabled(true);
            if (this.mainFrame != null) {
                this.mainFrame.updateSnsSelector();
                this.mainFrame.updateResamplingMode();
            }
            this.showRelatedFrames(false);
            this.showRelatedFrames(true);
        }
    }

    public void activeChanged() {
        this.dataState();
    }

    /*
     * WARNING - void declaration
     */
    private void checkForMissingHeaderEntries() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SNS sNS : SuiteManager.INSTANCE.getKnowledgebase().getStationsKnowledge().getAllActiveSNS()) {
            for (Site site : sNS.getAllSitesCenterFirst()) {
                if (!site.getTraceActive().equals((Object)Site.TraceActive.YES)) continue;
                for (String string : new String[]{site.getTraceZ(), site.getTraceNS(), site.getTraceEW()}) {
                    if (string == null) continue;
                    boolean bl = false;
                    for (String string2 : this.headerDatabase.listTraces()) {
                        if (!string2.equals(string)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    arrayList.add(string);
                }
            }
        }
        if (arrayList.size() > 0) {
            void var2_4;
            String string = "";
            for (String string3 : arrayList) {
                String string4 = (String)var2_4 + string3 + "<br>";
            }
            LogUtil.error(this.getClass(), (String)("<html>Problem loading data, following traces are defined in the stations knowbase but not in the header:<br>" + (String)var2_4 + "</html>"), (boolean)true);
        }
    }

    private void showRelatedFrames(boolean bl) {
        if (bl) {
            this.tools.startTool("edu.geophys.sonoview.SonoViewApplication");
        } else {
            this.tools.stopTools();
        }
    }

    void createAndShowGui() {
        this.getMainFrame();
    }

    public final AbstractAction getLoadHeaderAction() {
        return this.loadHeaderAction;
    }

    public final AbstractAction getLoadHeaderAction(final File file) {
        return new Action("Load Data " + file.getName(), "Load data " + file.getName(), false){
            private static final long serialVersionUID = -2893408136111928224L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SeisServApplication.this.config.setDataSource(SeisServConfiguration.DATA_SOURCE.HEADER);
                SeisServApplication.this.unloadHeader();
                SeisServApplication.this.dataState();
                SeisServApplication.this.loadHeader(file);
                SeisServApplication.this.config.store();
                SeisServApplication.this.dataState();
            }
        };
    }

    public final DTPServerWindow getMainFrame() {
        if (this.mainFrame == null) {
            ThemeManager.getInstance().setMode(this.config.getTheme());
            this.mainFrame = new DTPServerWindow("SeisServ", this);
            this.mainFrame.setDefaultCloseOperation(0);
            this.mainFrame.setSize(this.config.getSeisServFrameSize());
            this.mainFrame.setMinimumSize(new Dimension(650, 400));
            this.mainFrame.setLocation(this.config.getSeisServFramePosition());
            FramePositionHelper.ensureFrameOnScreen((JFrame)this.mainFrame);
            this.mainFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    SeisServApplication.this.onExit();
                }
            });
            this.mainFrame.setVisible(true);
        }
        return this.mainFrame;
    }

    public final AbstractAction getUnloadHeaderAction() {
        return this.unloadHeaderAction;
    }

    public final AbstractAction getEditKnowledgeAction() {
        return this.editKnowledgeAction;
    }

    private final void loadHeader(File file) {
        for (File file2 : this.headerDatabase.listHeaders()) {
            this.headerDatabase.removeHeader(file2);
        }
        this.headerDatabase = new HeaderDatabase();
        this.headerDatabase.addHeader(file);
        SuiteManager.INSTANCE.setCurrentData(new ProjectDirectories(file), this.headerDatabase);
        this.getMainFrame().setHeaderFile(file);
        this.appendRecentHeaders(file);
        this.config.setLastOpenedHeader(file.getAbsoluteFile());
    }

    public final void appendRecentHeaders(File file) {
        int n;
        if (!file.exists()) {
            return;
        }
        File[] fileArray = this.config.getHeaderHistory();
        String string = file.getAbsolutePath();
        File[] fileArray2 = fileArray;
        int n2 = fileArray2.length;
        for (n = 0; n < n2; ++n) {
            File file2 = fileArray2[n];
            if (!file2.getAbsolutePath().equals(string)) continue;
            return;
        }
        int n3 = Math.min(fileArray.length + 1, 6);
        File[] fileArray3 = new File[n3];
        fileArray3[0] = file;
        for (n = 1; n < n3; ++n) {
            fileArray3[n] = fileArray[n - 1];
        }
        this.config.setHeaderHistory(fileArray3);
    }

    public final void onExit() {
        this.config.setseisServFramePosition(this.mainFrame.getLocation());
        this.config.setseisServFrameSize(this.mainFrame.getSize());
        this.config.store();
        this.showRelatedFrames(false);
        this.getMainFrame().setVisible(false);
        this.getMainFrame().dispose();
        System.exit(0);
    }

    public final SeisServConfiguration getConfig() {
        return this.config;
    }

    public final void setConfig(SeisServConfiguration seisServConfiguration) {
        this.config = seisServConfiguration;
    }

    public Tools getTools() {
        return this.tools;
    }

    public void setTools(Tools tools) {
        this.tools = tools;
    }

    private static abstract class Action
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public Action(String string, String string2, boolean bl) {
            this.putValue("Name", string);
            this.putValue("ShortDescription", string2);
            this.setEnabled(bl);
        }
    }
}

