/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.seisserv.swing;

import edu.geophys.commons.model.knowledgebase.Knowledgebase;
import edu.geophys.commons.resamplingmodes.DefaultResamplingModes;
import edu.geophys.commons.resamplingmodes.ResamplingMode;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.seisserv.SeisServApplication;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;

public class ResampleModeSelector
extends JComboBox<ResamplingMode> {
    private final SeisServApplication seisServ;

    public ResampleModeSelector(SeisServApplication seisServApplication) {
        this.setModel(new DefaultComboBoxModel<ResamplingMode>(DefaultResamplingModes.MODES));
        this.setRenderer(new ResampleModeSelectorRenderer());
        this.seisServ = seisServApplication;
    }

    private ItemListener createItemListener() {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    ResamplingMode resamplingMode = (ResamplingMode)ResampleModeSelector.this.getSelectedItem();
                    ResampleModeSelector.this.updateToolTip();
                    Knowledgebase knowledgebase = SuiteManager.INSTANCE.getKnowledgebase();
                    if (knowledgebase != null) {
                        knowledgebase.getCampaignKnowledge().setResamplingMode(ResampleModeSelector.this.getSelectedIndex());
                        knowledgebase.getCampaignKnowledge().store();
                        ResampleModeSelector.this.seisServ.activeChanged();
                    }
                }
            }
        };
    }

    public void loadSelection() {
        for (ItemListener itemListener : this.getItemListeners()) {
            this.removeItemListener(itemListener);
        }
        Knowledgebase knowledgebase = SuiteManager.INSTANCE.getKnowledgebase();
        if (knowledgebase != null) {
            try {
                this.setSelectedIndex(knowledgebase.getCampaignKnowledge().getResamplingMode());
                this.updateToolTip();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.addItemListener(this.createItemListener());
        }
    }

    private void updateToolTip() {
        try {
            this.setToolTipText(((ResamplingMode)this.getSelectedItem()).toString(true));
        }
        catch (Exception exception) {
            this.setToolTipText("");
        }
    }

    public class ResampleModeSelectorRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof ResamplingMode) {
                object = ((ResamplingMode)object).toString();
            }
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            return this;
        }
    }
}

