/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.seisserv.swing;

import edu.geophys.commons.suite.ApplicationPlugin;
import edu.geophys.commons.util.LogUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class Tools {
    private static final long serialVersionUID = -786331681439389010L;
    private static List<Tool> tools = new ArrayList<Tool>();

    @Deprecated
    public void startTool(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            if (ApplicationPlugin.class.isAssignableFrom(clazz)) {
                this.startTool(clazz);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void updateToolState() {
        ArrayList<Tool> arrayList = new ArrayList<Tool>();
        for (Tool tool : tools) {
            if (tool.isRunning()) continue;
            arrayList.add(tool);
        }
        tools.removeAll(arrayList);
    }

    public void startTool(Class<? extends ApplicationPlugin> clazz) {
        this.updateToolState();
        for (Tool tool : tools) {
            if (tool.getApplicationPluginClass() != clazz) continue;
            LogUtil.error(this.getClass(), (String)(tool.getApplicationName() + " is already running."), (boolean)true);
            return;
        }
        tools.add(new Tool(clazz));
    }

    @Deprecated
    public void stopTools() {
        for (Tool tool : tools) {
            tool.stopTool();
        }
        tools.clear();
    }

    private static class Tool {
        private static final long serialVersionUID = -8753800254032068245L;
        private String name;
        private final Class<? extends ApplicationPlugin> applicationPluginClass;
        private ApplicationPlugin applicationPlugin;

        public void stopTool() {
            this.applicationPlugin.shutdown();
        }

        public Tool(Class<? extends ApplicationPlugin> clazz) {
            this.applicationPluginClass = clazz;
            try {
                this.name = this.applicationPluginClass.newInstance().getName();
                System.gc();
                try {
                    this.applicationPlugin = this.applicationPluginClass.newInstance();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            applicationPlugin.initialize();
                        }
                    });
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }

        public Class<? extends ApplicationPlugin> getApplicationPluginClass() {
            return this.applicationPluginClass;
        }

        public String getApplicationName() {
            return this.applicationPlugin.getName();
        }

        public boolean isRunning() {
            return this.applicationPlugin.isRunning();
        }
    }
}

