/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.seisserv.swing.knowledgebase;

import edu.geophys.commons.model.SNS;
import edu.geophys.commons.model.Site;
import edu.geophys.commons.util.CoordinateUtil;
import edu.geophys.seisserv.SeisServ;
import edu.geophys.seisserv.swing.knowledgebase.KnowledgeContainer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class JSNSSitePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final String[] traceIds = SeisServ.getApplication().getModel().listTraces();
    private final SNS.SNSSiteType[] siteTypes;
    private SNS.SNSSiteType selectedSiteType;
    private final Site site;
    private final KnowledgeContainer knowledge;
    private final SNS sns;
    private JFormattedTextField ftfClock;
    private JFormattedTextField ftfStatic;
    private JFormattedTextField ftfXOffset;
    private JFormattedTextField ftfYOffset;
    private JFormattedTextField ftfZOffset;
    private JButton posAsBaziButton;
    private JButton posAsLatLonButton;
    private JTextField siteIdTextField;
    private JComboBox snsPosComboBox;
    private JComboBox traceActiveComboBox;
    private JComboBox traceEWIdComboBox;
    private JComboBox traceNSIdComboBox;
    private JComboBox traceZIdComboBox;

    public JSNSSitePanel(SNS.SNSSiteType sNSSiteType, Site site, SNS.SNSSiteType[] sNSSiteTypeArray, KnowledgeContainer knowledgeContainer, SNS sNS) {
        this.siteTypes = sNSSiteTypeArray;
        this.site = site;
        this.selectedSiteType = sNSSiteType != null ? sNSSiteType : sNSSiteTypeArray[0];
        this.knowledge = knowledgeContainer;
        this.sns = sNS;
        this.initComponents();
        this.updateFormValues();
    }

    private void updateFormValues() {
        this.snsPosComboBox.setSelectedItem(this.selectedSiteType);
        this.siteIdTextField.setText(this.site.getId());
        this.traceZIdComboBox.setSelectedItem(this.site.getTraceZ());
        this.traceEWIdComboBox.setSelectedItem(this.site.getTraceEW());
        this.traceNSIdComboBox.setSelectedItem(this.site.getTraceNS());
        this.ftfXOffset.setValue(this.site.getXOffsetKm());
        this.ftfYOffset.setValue(this.site.getYOffsetKm());
        this.ftfZOffset.setValue(this.site.getZOffsetKm());
        this.ftfStatic.setValue(this.site.getStaticMs());
        this.ftfClock.setValue(this.site.getClockMs());
        this.traceActiveComboBox.setSelectedItem(this.site.getTraceActive());
    }

    public SNS.SNSSiteType getSelectedSiteType() {
        return this.selectedSiteType;
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        this.traceZIdComboBox = new JComboBox();
        this.ftfStatic = new JFormattedTextField();
        JLabel jLabel3 = new JLabel();
        this.ftfClock = new JFormattedTextField();
        JLabel jLabel4 = new JLabel();
        this.traceEWIdComboBox = new JComboBox();
        JLabel jLabel5 = new JLabel();
        this.traceNSIdComboBox = new JComboBox();
        JLabel jLabel6 = new JLabel();
        this.ftfXOffset = new JFormattedTextField();
        this.ftfYOffset = new JFormattedTextField();
        JLabel jLabel7 = new JLabel();
        this.ftfZOffset = new JFormattedTextField();
        JLabel jLabel8 = new JLabel();
        JLabel jLabel9 = new JLabel();
        this.siteIdTextField = new JTextField();
        JLabel jLabel10 = new JLabel();
        this.traceActiveComboBox = new JComboBox();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel11 = new JLabel();
        this.snsPosComboBox = new JComboBox();
        this.posAsBaziButton = new JButton();
        this.posAsLatLonButton = new JButton();
        jPanel.setBorder(BorderFactory.createTitledBorder("Site Properties"));
        jLabel.setText("Static::");
        jLabel2.setText("TraceZ Id:");
        this.traceZIdComboBox.setEditable(true);
        this.traceZIdComboBox.setModel(new DefaultComboBoxModel<String>(this.traceIds));
        this.traceZIdComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JSNSSitePanel.this.traceZIdComboBoxItemStateChanged(itemEvent);
            }
        });
        this.ftfStatic.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("# ms"))));
        this.ftfStatic.setHorizontalAlignment(11);
        this.ftfStatic.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JSNSSitePanel.this.ftfStaticPropertyChange(propertyChangeEvent);
            }
        });
        jLabel3.setText("Clock:");
        this.ftfClock.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("# ms"))));
        this.ftfClock.setHorizontalAlignment(11);
        this.ftfClock.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JSNSSitePanel.this.ftfClockPropertyChange(propertyChangeEvent);
            }
        });
        jLabel4.setText("TraceEW Id:");
        this.traceEWIdComboBox.setEditable(true);
        this.traceEWIdComboBox.setModel(new DefaultComboBoxModel<String>(this.traceIds));
        this.traceEWIdComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JSNSSitePanel.this.traceEWIdComboBoxItemStateChanged(itemEvent);
            }
        });
        jLabel5.setText("TraceNS Id:");
        this.traceNSIdComboBox.setEditable(true);
        this.traceNSIdComboBox.setModel(new DefaultComboBoxModel<String>(this.traceIds));
        this.traceNSIdComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JSNSSitePanel.this.traceNSIdComboBoxItemStateChanged(itemEvent);
            }
        });
        jLabel6.setText("x-Offset:");
        this.ftfXOffset.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0.00### km"))));
        this.ftfXOffset.setHorizontalAlignment(11);
        this.ftfXOffset.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JSNSSitePanel.this.ftfXOffsetPropertyChange(propertyChangeEvent);
            }
        });
        this.ftfYOffset.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0.00### km"))));
        this.ftfYOffset.setHorizontalAlignment(11);
        this.ftfYOffset.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JSNSSitePanel.this.ftfYOffsetPropertyChange(propertyChangeEvent);
            }
        });
        jLabel7.setText("y-Offset:");
        this.ftfZOffset.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0.00### km"))));
        this.ftfZOffset.setHorizontalAlignment(11);
        this.ftfZOffset.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JSNSSitePanel.this.ftfZOffsetPropertyChange(propertyChangeEvent);
            }
        });
        jLabel8.setText("z-Offset:");
        jLabel9.setText("Site Id:");
        this.siteIdTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                JSNSSitePanel.this.siteIdTextFieldFocusLost(focusEvent);
            }
        });
        jLabel10.setText("Active:");
        this.traceActiveComboBox.setModel(new DefaultComboBoxModel<Site.TraceActive>(Site.TraceActive.values()));
        this.traceActiveComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JSNSSitePanel.this.traceActiveComboBoxItemStateChanged(itemEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel3).addComponent(jLabel2).addComponent(jLabel4).addComponent(jLabel5).addComponent(jLabel6).addComponent(jLabel7).addComponent(jLabel8).addComponent(jLabel).addComponent(jLabel9).addComponent(jLabel10)).addGap(44, 44, 44).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.siteIdTextField, -1, 472, Short.MAX_VALUE).addComponent(this.ftfClock, GroupLayout.Alignment.TRAILING, -1, 472, Short.MAX_VALUE).addComponent(this.ftfStatic, GroupLayout.Alignment.TRAILING, -1, 472, Short.MAX_VALUE).addComponent(this.ftfZOffset, GroupLayout.Alignment.TRAILING, -1, 472, Short.MAX_VALUE).addComponent(this.ftfYOffset, GroupLayout.Alignment.TRAILING, -1, 472, Short.MAX_VALUE).addComponent(this.ftfXOffset, GroupLayout.Alignment.TRAILING, -1, 472, Short.MAX_VALUE).addComponent(this.traceNSIdComboBox, GroupLayout.Alignment.TRAILING, 0, 501, Short.MAX_VALUE).addComponent(this.traceEWIdComboBox, GroupLayout.Alignment.TRAILING, 0, 472, Short.MAX_VALUE).addComponent(this.traceZIdComboBox, 0, 472, Short.MAX_VALUE).addComponent(this.traceActiveComboBox, 0, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel9).addComponent(this.siteIdTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.traceZIdComboBox, -2, -1, -2).addComponent(jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.traceEWIdComboBox, -2, -1, -2).addComponent(jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.traceNSIdComboBox, -2, -1, -2).addComponent(jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ftfXOffset, -2, -1, -2).addComponent(jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ftfYOffset, -2, -1, -2).addComponent(jLabel7)).addGap(8, 8, 8).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ftfZOffset, -2, -1, -2).addComponent(jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ftfStatic, -2, -1, -2).addComponent(jLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ftfClock, -2, -1, -2).addComponent(jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 8, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel10).addComponent(this.traceActiveComboBox, -2, -1, -2)).addContainerGap()));
        jPanel2.setBorder(BorderFactory.createTitledBorder("SNS"));
        jLabel11.setText("Position in SNS:");
        this.snsPosComboBox.setModel(new DefaultComboBoxModel<SNS.SNSSiteType>(this.siteTypes));
        this.snsPosComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JSNSSitePanel.this.snsPosComboBoxItemStateChanged(itemEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout(jPanel2);
        jPanel2.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.snsPosComboBox, 0, 471, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel11).addComponent(this.snsPosComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.posAsBaziButton.setText("Set positon as Backazimuth");
        this.posAsBaziButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSNSSitePanel.this.posAsBaziButtonActionPerformed(actionEvent);
            }
        });
        this.posAsLatLonButton.setText("Set positon as Lat/Lon (inaccurate)");
        this.posAsLatLonButton.setToolTipText("<html>Setting the coordinates of a station in WGS84 (lat/lon)<br>coordinates can lead to inaccurate locations.<br><html>");
        this.posAsLatLonButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSNSSitePanel.this.posAsLatLonButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout3 = new GroupLayout(this);
        this.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(jPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addContainerGap(231, Short.MAX_VALUE).addComponent(this.posAsLatLonButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.posAsBaziButton)));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addComponent(jPanel2, -2, 54, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.posAsBaziButton).addComponent(this.posAsLatLonButton))));
    }

    private void traceActiveComboBoxItemStateChanged(ItemEvent itemEvent) {
        this.site.setTraceActive((Site.TraceActive)this.traceActiveComboBox.getSelectedItem());
    }

    private void snsPosComboBoxItemStateChanged(ItemEvent itemEvent) {
        this.selectedSiteType = (SNS.SNSSiteType)this.snsPosComboBox.getSelectedItem();
    }

    private void traceZIdComboBoxItemStateChanged(ItemEvent itemEvent) {
        this.site.setTraceZ((String)this.traceZIdComboBox.getSelectedItem());
    }

    private void traceEWIdComboBoxItemStateChanged(ItemEvent itemEvent) {
        this.site.setTraceEW((String)this.traceEWIdComboBox.getSelectedItem());
    }

    private void traceNSIdComboBoxItemStateChanged(ItemEvent itemEvent) {
        this.site.setTraceNS((String)this.traceNSIdComboBox.getSelectedItem());
    }

    private void ftfXOffsetPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("value")) {
            this.site.setXOffsetKm(Double.valueOf(this.ftfXOffset.getValue().toString()).doubleValue());
        }
    }

    private void ftfYOffsetPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("value")) {
            this.site.setYOffsetKm(Double.valueOf(this.ftfYOffset.getValue().toString()).doubleValue());
        }
    }

    private void ftfZOffsetPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("value")) {
            this.site.setZOffsetKm(Double.valueOf(this.ftfZOffset.getValue().toString()).doubleValue());
        }
    }

    private void ftfStaticPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("value")) {
            this.site.setStaticMs(Long.valueOf(this.ftfStatic.getValue().toString()).longValue());
        }
    }

    private void ftfClockPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("value")) {
            this.site.setClockMs(Long.valueOf(this.ftfClock.getValue().toString()).longValue());
        }
    }

    private void siteIdTextFieldFocusLost(FocusEvent focusEvent) {
        this.site.setId(this.siteIdTextField.getText());
    }

    private void posAsLatLonButtonActionPerformed(ActionEvent actionEvent) {
        Double d = null;
        Double d2 = null;
        d = this.getDoubleFromUser("Insert Latitude", "Please insert the Latitude value [decimal]:", 0.0);
        if (d == null) {
            return;
        }
        d2 = this.getDoubleFromUser("Insert Longitude", "Please insert the Longitude value [decimal]:", 0.0);
        if (d2 == null) {
            return;
        }
        CoordinateUtil.RelativeResult relativeResult = CoordinateUtil.convertAbsoluteToRelative((double)this.knowledge.getCampaignKnowledge().getReferencePoint().getLatitude(), (double)this.knowledge.getCampaignKnowledge().getReferencePoint().getLongitude(), (double)d, (double)d2);
        this.site.setXOffsetKm(relativeResult.xOffset);
        this.site.setYOffsetKm(relativeResult.yOffset);
        this.updateFormValues();
    }

    private void posAsBaziButtonActionPerformed(ActionEvent actionEvent) {
        Double d = null;
        Double d2 = null;
        Double d3 = null;
        Double d4 = null;
        d = this.getDoubleFromUser("Insert Backazimuth", "Please insert the Backazimuth value [degree]:", 0.0);
        if (d == null) {
            return;
        }
        d2 = this.getDoubleFromUser("Insert Distance", "Please insert the Distance value [m]:", 0.0);
        if (d2 == null) {
            return;
        }
        d3 = this.getDoubleFromUser("Insert x0", "Please insert the x offset value [km]:", this.sns.getCenter() != null ? this.sns.getCenter().getXOffsetKm() : 0.0);
        if (d3 == null) {
            return;
        }
        d4 = this.getDoubleFromUser("Insert y0", "Please insert the y offset value [km]:", this.sns.getCenter() != null ? this.sns.getCenter().getYOffsetKm() : 0.0);
        if (d4 == null) {
            return;
        }
        CoordinateUtil.RelativeResult relativeResult = CoordinateUtil.convertBackazimuthToRelative((double)d, (double)(d2 / 1000.0), (double)d3, (double)d4);
        this.site.setXOffsetKm(relativeResult.xOffset);
        this.site.setYOffsetKm(relativeResult.yOffset);
        this.updateFormValues();
    }

    private Double getDoubleFromUser(String string, String string2, double d) {
        String string3;
        while ((string3 = (String)JOptionPane.showInputDialog(this, string2, string, -1, null, null, d)) != null) {
            try {
                return Double.parseDouble(string3);
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            break;
        }
        return null;
    }
}

