/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.seisserv.swing.knowledgebase;

import edu.geophys.commons.model.SNS;
import edu.geophys.commons.model.Site;
import edu.geophys.commons.model.knowledgebase.StationsKnowledge;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.seisserv.SeisServ;
import edu.geophys.seisserv.swing.knowledgebase.JSNSSitePanel;
import edu.geophys.seisserv.swing.knowledgebase.KnowledgeContainer;
import edu.geophys.seisserv.swing.knowledgebase.KnowledgePanel;
import edu.geophys.seisserv.swing.knowledgebase.SNSTableModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JStationsKnowledgePanel
extends JPanel
implements KnowledgePanel {
    private boolean editingEnabled = false;
    private KnowledgeContainer model = null;
    private JButton downSNSButton;
    private JButton editSNSButton;
    private JButton editSiteButton;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JButton newSNSButton;
    private JButton newSiteButton;
    private JButton removeSNSButton;
    private JButton removeSiteButton;
    private JTable sitesTable;
    private JList snsList;
    private JButton upSNSButton;
    private JButton switchActiveSNSButton;

    public JStationsKnowledgePanel() {
        this.initComponents();
        this.sitesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JStationsKnowledgePanel.this.updateEditingState();
            }
        });
    }

    @Override
    public KnowledgeContainer getModel() {
        return this.model;
    }

    @Override
    public boolean isEditingEnabled() {
        return this.editingEnabled;
    }

    @Override
    public void setEditingEnabled(boolean bl) {
        this.editingEnabled = bl;
        this.updateEditingState();
    }

    private void updateTableModel() {
        int n = this.snsList.getSelectedIndex();
        if (n > -1) {
            SNS sNS = this.getSNSListModel().get(n);
            this.sitesTable.setModel(new SNSTableModel(sNS));
        } else {
            this.sitesTable.setModel(new SNSTableModel(null));
        }
        this.updateEditingState();
    }

    private void updateEditingState() {
        int n = this.snsList.getSelectedIndex();
        int n2 = this.sitesTable.getSelectedRow();
        if (n > -1) {
            SNS sNS = this.getSNSListModel().get(n);
            boolean bl = false;
            for (SNS.SNSSiteType sNSSiteType : SNS.SNSSiteType.values()) {
                if (sNS.getSite(sNSSiteType) != null) continue;
                bl = true;
            }
            this.editSNSButton.setEnabled(this.isEditingEnabled());
            this.switchActiveSNSButton.setEnabled(this.isEditingEnabled());
            this.upSNSButton.setEnabled(this.isEditingEnabled());
            this.downSNSButton.setEnabled(this.isEditingEnabled());
            this.removeSNSButton.setEnabled(this.isEditingEnabled());
            this.newSiteButton.setEnabled(this.isEditingEnabled() && bl);
        } else {
            this.editSNSButton.setEnabled(false);
            this.switchActiveSNSButton.setEnabled(false);
            this.upSNSButton.setEnabled(false);
            this.downSNSButton.setEnabled(false);
            this.removeSNSButton.setEnabled(false);
            this.newSiteButton.setEnabled(false);
        }
        if (n > -1 && n2 > -1) {
            this.editSiteButton.setEnabled(true);
            this.removeSiteButton.setEnabled(true);
        } else {
            this.editSiteButton.setEnabled(false);
            this.removeSiteButton.setEnabled(false);
        }
        this.sitesTable.setEnabled(this.isEditingEnabled());
        this.newSNSButton.setEnabled(this.isEditingEnabled());
    }

    @Override
    public void setModel(KnowledgeContainer knowledgeContainer) {
        this.model = knowledgeContainer;
        this.snsList.setModel(new SNSListModel(this.model.getStationsKnowledge()));
    }

    private SNSListModel getSNSListModel() {
        return (SNSListModel)this.snsList.getModel();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.snsList = new JList();
        this.editSNSButton = new JButton();
        this.switchActiveSNSButton = new JButton();
        this.upSNSButton = new JButton();
        this.removeSNSButton = new JButton();
        this.downSNSButton = new JButton();
        this.newSNSButton = new JButton();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.sitesTable = new JTable();
        this.editSiteButton = new JButton();
        this.newSiteButton = new JButton();
        this.removeSiteButton = new JButton();
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("SNS List"));
        this.snsList.setModel(new SNSListModel());
        this.snsList.setSelectionMode(0);
        this.snsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JStationsKnowledgePanel.this.snsListValueChanged(listSelectionEvent);
            }
        });
        this.jScrollPane2.setViewportView(this.snsList);
        this.editSNSButton.setText("Edit");
        this.editSNSButton.setEnabled(false);
        this.editSNSButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JStationsKnowledgePanel.this.editSNSButtonActionPerformed(actionEvent);
            }
        });
        this.switchActiveSNSButton.setText("Switch active status");
        this.switchActiveSNSButton.setEnabled(false);
        this.switchActiveSNSButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JStationsKnowledgePanel.this.switchActiveSNSButtonActionPerformed(actionEvent);
            }
        });
        this.upSNSButton.setText("Up");
        this.upSNSButton.setEnabled(false);
        this.upSNSButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JStationsKnowledgePanel.this.upSNSButtonActionPerformed(actionEvent);
            }
        });
        this.removeSNSButton.setText("Remove");
        this.removeSNSButton.setEnabled(false);
        this.removeSNSButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JStationsKnowledgePanel.this.removeSNSButtonActionPerformed(actionEvent);
            }
        });
        this.downSNSButton.setText("Down");
        this.downSNSButton.setEnabled(false);
        this.downSNSButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JStationsKnowledgePanel.this.downSNSButtonActionPerformed(actionEvent);
            }
        });
        this.newSNSButton.setText("New");
        this.newSNSButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JStationsKnowledgePanel.this.newSNSButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 541, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.switchActiveSNSButton, -1, -1, Short.MAX_VALUE).addComponent(this.upSNSButton, -1, -1, Short.MAX_VALUE).addComponent(this.editSNSButton, -1, -1, Short.MAX_VALUE).addComponent(this.removeSNSButton, -1, -1, Short.MAX_VALUE).addComponent(this.downSNSButton, -1, -1, Short.MAX_VALUE).addComponent(this.newSNSButton, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING, -1, 225, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.switchActiveSNSButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.upSNSButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downSNSButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 44, Short.MAX_VALUE).addComponent(this.editSNSButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 44, Short.MAX_VALUE).addComponent(this.newSNSButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeSNSButton))).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("SNS Sites"));
        this.sitesTable.setModel(new SNSTableModel(null));
        this.sitesTable.setEnabled(false);
        this.sitesTable.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.sitesTable);
        this.editSiteButton.setText("Edit");
        this.editSiteButton.setEnabled(false);
        this.editSiteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JStationsKnowledgePanel.this.editSiteButtonActionPerformed(actionEvent);
            }
        });
        this.newSiteButton.setText("New");
        this.newSiteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JStationsKnowledgePanel.this.newSiteButtonActionPerformed(actionEvent);
            }
        });
        this.removeSiteButton.setText("Remove");
        this.removeSiteButton.setEnabled(false);
        this.removeSiteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JStationsKnowledgePanel.this.removeSiteButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 541, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.editSiteButton, -1, -1, Short.MAX_VALUE).addComponent(this.newSiteButton, -1, -1, Short.MAX_VALUE).addComponent(this.removeSiteButton, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, -1, 169, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addComponent(this.editSiteButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 88, Short.MAX_VALUE).addComponent(this.newSiteButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeSiteButton))).addContainerGap()));
        GroupLayout groupLayout3 = new GroupLayout(this);
        this.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addContainerGap()));
    }

    private void snsListValueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.updateTableModel();
        }
    }

    private void switchActiveSNSButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.snsList.getSelectedIndex();
        this.getSNSListModel().switchActive(n);
        this.snsList.setSelectedIndex(n > 0 ? n - 1 : n);
    }

    private void upSNSButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.snsList.getSelectedIndex();
        this.getSNSListModel().moveUp(n);
        this.snsList.setSelectedIndex(n > 0 ? n - 1 : n);
    }

    private void downSNSButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.snsList.getSelectedIndex();
        this.getSNSListModel().moveDown(n);
        this.snsList.setSelectedIndex(n < this.getSNSListModel().getSize() - 1 ? n + 1 : n);
    }

    private void removeSNSButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.snsList.getSelectedIndex();
        this.getSNSListModel().remove(n);
        this.snsList.setSelectedIndex(n < this.getSNSListModel().getSize() ? n : n - 1);
    }

    private void editSNSButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.snsList.getSelectedIndex();
        if (n > -1) {
            SNS sNS = this.getSNSListModel().get(n);
            String string = sNS.getID();
            String string2 = sNS.getLayermodel();
            JTextField jTextField = new JTextField(5);
            jTextField.setText(string);
            JTextField jTextField2 = new JTextField(5);
            jTextField2.setText(string2);
            JPanel jPanel = new JPanel();
            jPanel.add(new JLabel("SNS ID:"));
            jPanel.add(jTextField);
            jPanel.add(Box.createHorizontalStrut(15));
            jPanel.add(new JLabel("SNS layer model (optional):"));
            jPanel.add(jTextField2);
            int n2 = JOptionPane.showConfirmDialog(SeisServ.getApplication().getMainFrame(), jPanel, "Please Enter the new SNS ID and optional layer model", 2);
            if (n2 == 0 && jTextField.getText().length() > 0) {
                sNS.setID(jTextField.getText());
                sNS.setLayermodel(jTextField2.getText());
                this.getSNSListModel().set(n, sNS);
            }
        }
    }

    private void newSNSButtonActionPerformed(ActionEvent actionEvent) {
        SNS sNS = new SNS();
        String string = sNS.getID();
        String string2 = sNS.getLayermodel();
        JTextField jTextField = new JTextField(5);
        jTextField.setText(string);
        JTextField jTextField2 = new JTextField(5);
        jTextField2.setText(string2);
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel("SNS ID:"));
        jPanel.add(jTextField);
        jPanel.add(Box.createHorizontalStrut(15));
        jPanel.add(new JLabel("SNS layer model (optional):"));
        jPanel.add(jTextField2);
        int n = JOptionPane.showConfirmDialog(SeisServ.getApplication().getMainFrame(), jPanel, "Please Enter SNS ID and optional layer model", 2);
        if (n == 0 && jTextField.getText().length() > 0) {
            sNS.setID(jTextField.getText());
            sNS.setLayermodel(jTextField2.getText());
            this.getSNSListModel().add(sNS);
        }
    }

    private void editSiteButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.snsList.getSelectedIndex();
        int n2 = this.sitesTable.getSelectedRow();
        if (n2 > -1) {
            SNS.SNSSiteType sNSSiteType;
            SNS sNS = this.getSNSListModel().get(n);
            SNSTableModel sNSTableModel = (SNSTableModel)this.sitesTable.getModel();
            SNS.SNSSiteType sNSSiteType2 = sNSTableModel.getSiteType(n2);
            Site site = sNS.getSite(sNSSiteType2);
            JSNSSitePanel jSNSSitePanel = new JSNSSitePanel(sNSSiteType2, site, SNS.SNSSiteType.values(), this.getModel(), sNS);
            JOptionPane.showMessageDialog(this, jSNSSitePanel, "Edit SNS Site", -1);
            if (site.getId() == null || site.getId().equals("")) {
                LogUtil.warn(this.getClass(), (String)"Site ID can not be empty!", (boolean)true);
            }
            if (sNS.getSite(sNSSiteType = jSNSSitePanel.getSelectedSiteType()) != null && sNS.getSite(sNSSiteType) != site) {
                sNS.setSite(sNSSiteType2, sNS.getSite(sNSSiteType));
            } else {
                sNS.setSite(sNSSiteType2, null);
            }
            sNS.setSite(sNSSiteType, site);
            this.updateTableModel();
        }
    }

    private void newSiteButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.snsList.getSelectedIndex();
        SNS sNS = this.getSNSListModel().get(n);
        Site site = new Site();
        ArrayList<SNS.SNSSiteType> arrayList = new ArrayList<SNS.SNSSiteType>();
        for (SNS.SNSSiteType sNSSiteType : SNS.SNSSiteType.values()) {
            if (sNS.getSite(sNSSiteType) != null) continue;
            arrayList.add(sNSSiteType);
        }
        JSNSSitePanel jSNSSitePanel = new JSNSSitePanel(null, site, arrayList.toArray(new SNS.SNSSiteType[arrayList.size()]), this.getModel(), sNS);
        JOptionPane.showMessageDialog(this, jSNSSitePanel, "New SNS Site", -1);
        if (site.getId() == null || site.getId().equals("")) {
            LogUtil.warn(this.getClass(), (String)"Site ID can not be empty!", (boolean)true);
        }
        SNS.SNSSiteType sNSSiteType = jSNSSitePanel.getSelectedSiteType();
        sNS.setSite(sNSSiteType, site);
        this.updateTableModel();
    }

    private void removeSiteButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.snsList.getSelectedIndex();
        int n2 = this.sitesTable.getSelectedRow();
        if (n2 > -1) {
            SNS sNS = this.getSNSListModel().get(n);
            SNSTableModel sNSTableModel = (SNSTableModel)this.sitesTable.getModel();
            SNS.SNSSiteType sNSSiteType = sNSTableModel.getSiteType(n2);
            sNS.setSite(sNSSiteType, null);
            this.updateTableModel();
        }
    }

    private static class SNSListModel
    extends AbstractListModel {
        private StationsKnowledge stations = null;

        public SNSListModel() {
        }

        public SNSListModel(StationsKnowledge stationsKnowledge) {
            this.stations = stationsKnowledge;
        }

        public SNS get(int n) {
            return this.stations != null ? this.stations.getAllSNS()[n] : null;
        }

        public void switchActive(int n) {
            if (this.stations != null && n >= 0) {
                SNS sNS;
                sNS.setEnabled(!(sNS = this.stations.getAllSNS()[n]).isEnabled());
                this.fireContentsChanged(this, n, n);
            }
        }

        public void moveUp(int n) {
            if (this.stations != null && n > 0) {
                ArrayList<SNS> arrayList = new ArrayList<SNS>(Arrays.asList(this.stations.getAllSNS()));
                SNS sNS = arrayList.get(n - 1);
                arrayList.set(n - 1, arrayList.get(n));
                arrayList.set(n, sNS);
                this.stations.setAllSNS(arrayList.toArray(new SNS[arrayList.size()]));
                this.fireContentsChanged(this, n - 1, n);
            }
        }

        public void moveDown(int n) {
            if (this.stations != null && n < this.getSize() - 1) {
                ArrayList<SNS> arrayList = new ArrayList<SNS>(Arrays.asList(this.stations.getAllSNS()));
                SNS sNS = arrayList.get(n + 1);
                arrayList.set(n + 1, arrayList.get(n));
                arrayList.set(n, sNS);
                this.stations.setAllSNS(arrayList.toArray(new SNS[arrayList.size()]));
                this.fireContentsChanged(this, n, n + 1);
            }
        }

        public void add(SNS sNS) {
            if (this.stations != null && sNS != null) {
                ArrayList<SNS> arrayList = new ArrayList<SNS>(Arrays.asList(this.stations.getAllSNS()));
                arrayList.add(sNS);
                this.stations.setAllSNS(arrayList.toArray(new SNS[arrayList.size()]));
                this.fireIntervalAdded(this, arrayList.size() - 1, arrayList.size() - 1);
            }
        }

        public void remove(int n) {
            if (this.stations != null) {
                ArrayList<SNS> arrayList = new ArrayList<SNS>(Arrays.asList(this.stations.getAllSNS()));
                arrayList.remove(n);
                this.stations.setAllSNS(arrayList.toArray(new SNS[arrayList.size()]));
                this.fireIntervalRemoved(this, n, n);
            }
        }

        @Override
        public String getElementAt(int n) {
            if (this.stations != null) {
                return this.stations.getAllSNS()[n].toString();
            }
            return null;
        }

        @Override
        public int getSize() {
            return this.stations != null ? this.stations.getAllSNS().length : 0;
        }

        public void set(int n, SNS sNS) {
            if (this.stations != null) {
                ArrayList<SNS> arrayList = new ArrayList<SNS>(Arrays.asList(this.stations.getAllSNS()));
                arrayList.set(n, sNS);
                this.stations.setAllSNS(arrayList.toArray(new SNS[arrayList.size()]));
                this.fireContentsChanged(this, n, n);
            }
        }
    }
}

