/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.seisserv.swing.knowledgebase;

import edu.geophys.commons.model.SNS;
import edu.geophys.commons.model.Site;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

class SNSTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 7710975160054433251L;
    private final Map.Entry<SNS.SNSSiteType, Site>[] model;
    private final SNS sns;

    public SNSTableModel(SNS sNS) {
        LinkedHashMap<SNS.SNSSiteType, Site> linkedHashMap = new LinkedHashMap<SNS.SNSSiteType, Site>();
        if (sNS != null) {
            for (SNS.SNSSiteType sNSSiteType : SNS.SNSSiteType.values()) {
                Site site = sNS.getSite(sNSSiteType);
                if (site == null) continue;
                linkedHashMap.put(sNSSiteType, site);
            }
        }
        this.model = linkedHashMap.entrySet().toArray(new Map.Entry[0]);
        this.sns = sNS;
    }

    @Override
    public int getColumnCount() {
        return Column.values().length;
    }

    public SNS.SNSSiteType getSiteType(int n) {
        return this.model[n].getKey();
    }

    @Override
    public int getRowCount() {
        return this.model.length;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        Column column = Column.values()[n2];
        switch (column) {
            case ACTIVE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Column column = Column.values()[n2];
        switch (column) {
            case ACTIVE: {
                this.model[n].getValue().setTraceActive((Site.TraceActive)object);
                this.fireTableCellUpdated(n, n2);
            }
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Column column = Column.values()[n2];
        Map.Entry<SNS.SNSSiteType, Site> entry = this.model[n];
        Object object = null;
        switch (column) {
            case SNSPOS: {
                object = entry.getKey().name().toLowerCase();
                break;
            }
            case SITEID: {
                object = entry.getValue().getId();
                break;
            }
            case TRACEZ: {
                object = entry.getValue().getTraceZ();
                break;
            }
            case TRACEEW: {
                object = entry.getValue().getTraceEW();
                break;
            }
            case TRACENS: {
                object = entry.getValue().getTraceNS();
                break;
            }
            case X: {
                object = entry.getValue().getXOffsetKm();
                break;
            }
            case Y: {
                object = entry.getValue().getYOffsetKm();
                break;
            }
            case Z: {
                object = entry.getValue().getZOffsetKm();
                break;
            }
            case STATIC: {
                object = entry.getValue().getStaticMs();
                break;
            }
            case CLOCK: {
                object = entry.getValue().getClockMs();
                break;
            }
            case ACTIVE: {
                object = entry.getValue().getTraceActive();
                break;
            }
            default: {
                object = "Not Set";
            }
        }
        return object;
    }

    @Override
    public String getColumnName(int n) {
        return Column.values()[n].name;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return Column.values()[n].type;
    }

    private static enum Column {
        SNSPOS(String.class, "Pos"),
        SITEID(String.class, "Id"),
        TRACEZ(String.class, "TraceZ"),
        TRACEEW(String.class, "TraceEW"),
        TRACENS(String.class, "TraceSN"),
        X(Double.class, "x"),
        Y(Double.class, "y"),
        Z(Double.class, "z"),
        STATIC(Double.class, "static"),
        CLOCK(Double.class, "clock"),
        ACTIVE(Site.TraceActive.class, "traceActive");

        public final Class<?> type;
        public final String name;

        private Column(Class<?> clazz, String string2) {
            this.type = clazz;
            this.name = string2;
        }
    }
}

