/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.chart;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLProfile;
import org.jzy3d.chart.ChartScene;
import org.jzy3d.chart.controllers.camera.AbstractCameraController;
import org.jzy3d.colors.Color;
import org.jzy3d.factories.JzyFactories;
import org.jzy3d.global.Settings;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Scale;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.axes.layout.IAxeLayout;
import org.jzy3d.plot3d.rendering.canvas.CanvasAWT;
import org.jzy3d.plot3d.rendering.canvas.CanvasNewt;
import org.jzy3d.plot3d.rendering.canvas.CanvasSwing;
import org.jzy3d.plot3d.rendering.canvas.ICanvas;
import org.jzy3d.plot3d.rendering.canvas.IScreenCanvas;
import org.jzy3d.plot3d.rendering.canvas.OffscreenCanvas;
import org.jzy3d.plot3d.rendering.canvas.Quality;
import org.jzy3d.plot3d.rendering.scene.Scene;
import org.jzy3d.plot3d.rendering.view.Renderer2d;
import org.jzy3d.plot3d.rendering.view.View;
import org.jzy3d.plot3d.rendering.view.modes.ViewPositionMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chart {
    public static Quality DEFAULT_QUALITY = Quality.Intermediate;
    public static String DEFAULT_WINDOWING_TOOLKIT = "awt";
    protected ChartScene scene;
    protected View view;
    protected ICanvas canvas;
    protected Coord3d previousViewPointFree;
    protected Coord3d previousViewPointTop;
    protected Coord3d previousViewPointProfile;
    protected ArrayList<AbstractCameraController> controllers;
    protected GLCapabilities capabilities;

    public Chart() {
        this(DEFAULT_QUALITY, DEFAULT_WINDOWING_TOOLKIT);
    }

    public Chart(Quality quality) {
        this(quality, DEFAULT_WINDOWING_TOOLKIT);
    }

    public Chart(String windowingToolkit) {
        this(DEFAULT_QUALITY, windowingToolkit);
    }

    public Chart(Quality quality, String windowingToolkit) {
        this(quality, windowingToolkit, Settings.getInstance().getGLCapabilities());
    }

    public Chart(Quality quality, String windowingToolkit, GLCapabilities capabilities) {
        this.capabilities = capabilities;
        this.controllers = new ArrayList(1);
        this.scene = this.initializeScene(quality.isAlphaActivated());
        this.canvas = this.initializeCanvas(this.scene, quality, windowingToolkit);
        this.view = this.canvas.getView();
        this.view.setBackgroundColor(Color.WHITE);
    }

    protected ICanvas initializeCanvas(Scene scene, Quality quality, String chartType) {
        if ("awt".compareTo(chartType) == 0) {
            return new CanvasAWT(scene, quality, (GLCapabilitiesImmutable)this.capabilities);
        }
        if ("swing".compareTo(chartType) == 0) {
            return new CanvasSwing(scene, quality, (GLCapabilitiesImmutable)this.capabilities);
        }
        if ("newt".compareTo(chartType) == 0) {
            return new CanvasNewt(scene, quality, (GLCapabilitiesImmutable)this.capabilities);
        }
        if (chartType.startsWith("offscreen")) {
            Pattern pattern = Pattern.compile("offscreen,(\\d+),(\\d+)");
            Matcher matcher = pattern.matcher(chartType);
            if (matcher.matches()) {
                int width = Integer.parseInt(matcher.group(1));
                int height = Integer.parseInt(matcher.group(2));
                return new OffscreenCanvas(scene, quality, GLProfile.getDefault(), width, height);
            }
            return new OffscreenCanvas(scene, quality, GLProfile.getDefault(), 500, 500);
        }
        throw new RuntimeException("unknown chart type:" + chartType);
    }

    protected ChartScene initializeScene(boolean graphsort) {
        return JzyFactories.scene.getInstance(graphsort);
    }

    public void clear() {
        this.scene.clear();
        this.view.shoot();
    }

    public void stopAnimator() {
        GLAnimatorControl control;
        if (this.canvas != null && this.canvas instanceof IScreenCanvas && (control = ((IScreenCanvas)this.canvas).getAnimator()) != null) {
            control.stop();
        }
    }

    public void dispose() {
        this.clearControllerList();
        this.canvas.dispose();
        this.scene.dispose();
        this.canvas = null;
        this.scene = null;
    }

    public void render() {
        this.view.shoot();
    }

    public BufferedImage screenshot() {
        return this.canvas.screenshot();
    }

    public void updateProjectionsAndRender() {
        this.getView().shoot();
        this.getView().project();
        this.render();
    }

    public void addController(AbstractCameraController controller) {
        controller.register(this);
        this.controllers.add(controller);
    }

    public void removeController(AbstractCameraController controller) {
        controller.unregister(this);
        this.controllers.remove(controller);
    }

    protected void clearControllerList() {
        for (AbstractCameraController controller : this.controllers) {
            controller.unregister(this);
        }
        this.controllers.clear();
    }

    public List<AbstractCameraController> getControllers() {
        return this.controllers;
    }

    public void addDrawable(AbstractDrawable drawable) {
        this.getScene().getGraph().add(drawable);
    }

    public void addDrawable(AbstractDrawable drawable, boolean updateViews) {
        this.getScene().getGraph().add(drawable, updateViews);
    }

    public void addDrawable(List<? extends AbstractDrawable> drawables, boolean updateViews) {
        this.getScene().getGraph().add(drawables, updateViews);
    }

    public void addDrawable(List<? extends AbstractDrawable> drawables) {
        this.getScene().getGraph().add(drawables);
    }

    public void removeDrawable(AbstractDrawable drawable) {
        this.getScene().getGraph().remove(drawable);
    }

    public void removeDrawable(AbstractDrawable drawable, boolean updateViews) {
        this.getScene().getGraph().remove(drawable, updateViews);
    }

    public void addRenderer(Renderer2d renderer2d) {
        this.view.addRenderer2d(renderer2d);
    }

    public void removeRenderer(Renderer2d renderer2d) {
        this.view.removeRenderer2d(renderer2d);
    }

    public View getView() {
        return this.view;
    }

    public ChartScene getScene() {
        return this.scene;
    }

    public ICanvas getCanvas() {
        return this.canvas;
    }

    public IAxeLayout getAxeLayout() {
        return this.getView().getAxe().getLayout();
    }

    public void setAxeDisplayed(boolean status) {
        this.view.setAxeBoxDisplayed(status);
        this.view.shoot();
    }

    public void setViewPoint(Coord3d viewPoint) {
        this.view.setViewPoint(viewPoint);
        this.view.shoot();
    }

    public Coord3d getViewPoint() {
        return this.view.getViewPoint();
    }

    public void setViewMode(ViewPositionMode mode) {
        ViewPositionMode previous = this.view.getViewMode();
        if (previous == ViewPositionMode.FREE) {
            this.previousViewPointFree = this.view.getViewPoint();
        } else if (previous == ViewPositionMode.TOP) {
            this.previousViewPointTop = this.view.getViewPoint();
        } else if (previous == ViewPositionMode.PROFILE) {
            this.previousViewPointProfile = this.view.getViewPoint();
        }
        this.view.setViewPositionMode(mode);
        if (mode == ViewPositionMode.FREE) {
            this.view.setViewPoint(this.previousViewPointFree == null ? View.DEFAULT_VIEW.clone() : this.previousViewPointFree);
        } else if (mode == ViewPositionMode.TOP) {
            this.view.setViewPoint(this.previousViewPointTop == null ? View.DEFAULT_VIEW.clone() : this.previousViewPointTop);
        } else if (mode == ViewPositionMode.PROFILE) {
            this.view.setViewPoint(this.previousViewPointProfile == null ? View.DEFAULT_VIEW.clone() : this.previousViewPointProfile);
        }
        this.view.shoot();
    }

    public ViewPositionMode getViewMode() {
        return this.view.getViewMode();
    }

    public void setScale(Scale scale, boolean notify) {
        this.view.setScale(scale, notify);
    }

    public void setScale(Scale scale) {
        this.setScale(scale, true);
    }

    public Scale getScale() {
        return new Scale(this.view.getBounds().getZmin(), this.view.getBounds().getZmax());
    }

    public float flip(float y) {
        return (float)this.canvas.getRendererHeight() - y;
    }

    public GLCapabilities getCapabilities() {
        return this.capabilities;
    }
}

