/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.chart.controllers.keyboard.camera;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import org.jzy3d.chart.Chart;
import org.jzy3d.chart.controllers.camera.AbstractCameraController;
import org.jzy3d.maths.Coord2d;

public class CameraKeyController
extends AbstractCameraController
implements KeyListener {
    public CameraKeyController() {
    }

    public CameraKeyController(Chart chart) {
        this.register(chart);
    }

    public void register(Chart chart) {
        super.register(chart);
        chart.getCanvas().addKeyListener(this);
    }

    public void dispose() {
        for (Chart c : this.targets) {
            c.getCanvas().removeKeyListener(this);
        }
        super.dispose();
    }

    public void keyPressed(KeyEvent e) {
        if (!e.isShiftDown()) {
            Coord2d move = new Coord2d();
            float offset = 0.1f;
            switch (e.getKeyCode()) {
                case 40: {
                    move.y -= offset;
                    this.rotate(move);
                    break;
                }
                case 38: {
                    move.y += offset;
                    this.rotate(move);
                    break;
                }
                case 37: {
                    move.x -= offset;
                    this.rotate(move);
                    break;
                }
                case 39: {
                    move.x += offset;
                    this.rotate(move);
                    break;
                }
            }
        } else {
            switch (e.getKeyCode()) {
                case 40: {
                    this.shift(0.1f);
                    break;
                }
                case 38: {
                    this.shift(-0.1f);
                    break;
                }
                case 37: {
                    this.zoomZ(0.9f);
                    break;
                }
                case 39: {
                    this.zoomZ(1.1f);
                    break;
                }
            }
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }
}

