/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.contour;

import java.awt.image.BufferedImage;
import org.jzy3d.contour.AbstractContourGenerator;
import org.jzy3d.contour.IContourColoringPolicy;
import org.jzy3d.contour.IContourPictureGenerator;
import org.jzy3d.maths.Range;
import org.jzy3d.plot3d.builder.Mapper;

public class MapperContourPictureGenerator
extends AbstractContourGenerator
implements IContourPictureGenerator {
    public static int PIXEL_NEIGHBOUR_THRESHOLD = 2;
    public static float LINE_STRIP_WIDTH = 2.0f;
    public static int MERGE_STRIP_DIST = 1;
    protected Mapper mapper;
    protected Range xrange;
    protected Range yrange;

    public MapperContourPictureGenerator(Mapper mapper, Range xrange, Range yrange) {
        this.mapper = mapper;
        this.xrange = xrange;
        this.yrange = yrange;
    }

    public double[][] getContourMatrix(int xRes, int yRes, int nLevels) {
        return this.computeContour(xRes, yRes, nLevels);
    }

    public BufferedImage getContourImage(IContourColoringPolicy policy, int xRes, int yRes, int nLevels) {
        double[][] contours = this.computeContour(xRes, yRes, nLevels);
        return this.buildImage(xRes, yRes, contours, policy);
    }

    public BufferedImage getContourImage(IContourColoringPolicy policy, int xRes, int yRes, double[] sortedLevels) {
        double[][] contours = this.computeContour(xRes, yRes, sortedLevels);
        return this.buildImage(xRes, yRes, contours, policy);
    }

    public BufferedImage getFilledContourImage(IContourColoringPolicy policy, int xRes, int yRes, int nLevels) {
        double[][] contours = this.computeFilledContour(xRes, yRes, nLevels);
        return this.buildImage(xRes, yRes, contours, policy);
    }

    public BufferedImage getHeightMap(IContourColoringPolicy policy, int xRes, int yRes, int nLevels) {
        double[][] contours = this.computeXYColors(xRes, yRes, nLevels);
        return this.buildImage(xRes, yRes, contours, policy);
    }

    protected BufferedImage buildImage(int xRes, int yRes, double[][] contours, IContourColoringPolicy policy) {
        BufferedImage image = new BufferedImage(xRes, yRes, 1);
        for (int x = 0; x < xRes; ++x) {
            for (int y = 0; y < yRes; ++y) {
                image.setRGB(x, y, policy.getRGB(contours[x][y]));
            }
        }
        return image;
    }

    protected void computeHeightMatrix(double[][] matrix, int xRes, int yRes) {
        this.minValue = Double.MAX_VALUE;
        this.maxValue = -1.7976931348623157E308;
        double xstep = this.xrange.getRange() / (double)(xRes - 1);
        double ystep = this.yrange.getRange() / (double)(yRes - 1);
        for (int xi = 0; xi < xRes; ++xi) {
            for (int yi = 0; yi < yRes; ++yi) {
                double value;
                double x = this.xrange.getMin() + (double)xi * xstep;
                double y = this.yrange.getMin() + (double)yi * ystep;
                matrix[xi][yRes - 1 - yi] = value = this.mapper.f(x, y);
                if (value < this.minValue) {
                    this.minValue = value;
                }
                if (!(value > this.maxValue)) continue;
                this.maxValue = value;
            }
        }
    }
}

