/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.maths;

public class Coord2d {
    public static final Coord2d ORIGIN = new Coord2d(0.0f, 0.0f);
    public static final Coord2d INVALID = new Coord2d(Float.NaN, Float.NaN);
    public float x;
    public float y;

    public Coord2d() {
        this.x = 0.0f;
        this.y = 0.0f;
    }

    public Coord2d(float xi, float yi) {
        this.x = xi;
        this.y = yi;
    }

    public Coord2d(double xi, double yi) {
        this.x = (float)xi;
        this.y = (float)yi;
    }

    public Coord2d clone() {
        return new Coord2d(this.x, this.y);
    }

    public Coord2d add(Coord2d c2) {
        return new Coord2d(this.x + c2.x, this.y + c2.y);
    }

    public void addSelf(Coord2d c2) {
        this.x += c2.x;
        this.y += c2.y;
    }

    public void addSelf(float x, float y) {
        this.x += x;
        this.y += y;
    }

    public Coord2d add(float value) {
        return new Coord2d(this.x + value, this.y + value);
    }

    public Coord2d add(float x, float y) {
        return new Coord2d(this.x + x, this.y + y);
    }

    public Coord2d sub(Coord2d c2) {
        return new Coord2d(this.x - c2.x, this.y - c2.y);
    }

    public Coord2d sub(float value) {
        return new Coord2d(this.x - value, this.y - value);
    }

    public Coord2d sub(float x, float y) {
        return new Coord2d(this.x - x, this.y - y);
    }

    public Coord2d mul(Coord2d c2) {
        return new Coord2d(this.x * c2.x, this.y * c2.y);
    }

    public Coord2d mul(float x, float y) {
        return new Coord2d(this.x * x, this.y * y);
    }

    public Coord2d mul(float value) {
        return new Coord2d(this.x * value, this.y * value);
    }

    public Coord2d div(Coord2d c2) {
        return new Coord2d(this.x / c2.x, this.y / c2.y);
    }

    public Coord2d div(float value) {
        return new Coord2d(this.x / value, this.y / value);
    }

    public Coord2d div(float x, float y) {
        return new Coord2d(this.x / x, this.y / y);
    }

    public void divSelf(float value) {
        this.x /= value;
        this.y /= value;
    }

    public Coord2d cartesian() {
        return new Coord2d(Math.cos(this.x) * (double)this.y, Math.sin(this.x) * (double)this.y);
    }

    public Coord2d polar() {
        return new Coord2d(Math.atan(this.y / this.x), Math.sqrt(this.x * this.x + this.y * this.y));
    }

    public Coord2d fullPolar() {
        double radius = Math.sqrt(this.x * this.x + this.y * this.y);
        if (this.x < 0.0f) {
            return new Coord2d(Math.atan(this.y / this.x) + Math.PI, radius);
        }
        if (this.x > 0.0f) {
            if (this.y >= 0.0f) {
                return new Coord2d(Math.atan(this.y / this.x), radius);
            }
            return new Coord2d(Math.atan(this.y / this.x) + Math.PI * 2, radius);
        }
        if (this.y > 0.0f) {
            return new Coord2d(1.5707963267948966, radius);
        }
        if (this.y < 0.0f) {
            return new Coord2d(4.71238898038469, radius);
        }
        return new Coord2d(0.0f, 0.0f);
    }

    public double distance(Coord2d c) {
        return Math.sqrt(Math.pow(this.x - c.x, 2.0) + Math.pow(this.y - c.y, 2.0));
    }

    public String toString() {
        return "x=" + this.x + " y=" + this.y;
    }

    public float[] toArray() {
        float[] array = new float[]{this.x, this.y};
        return array;
    }
}

