/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.maths;

import org.jzy3d.maths.Coord2d;

public class Coord3d {
    public static final Coord3d ORIGIN = new Coord3d(0.0f, 0.0f, 0.0f);
    public static final Coord3d IDENTITY = new Coord3d(1.0f, 1.0f, 1.0f);
    public static final Coord3d INVALID = new Coord3d(Float.NaN, Float.NaN, Float.NaN);
    private int fHashCode;
    public float x;
    public float y;
    public float z;

    public Coord3d() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public Coord3d(float xi, float yi, float zi) {
        this.x = xi;
        this.y = yi;
        this.z = zi;
    }

    public Coord3d(Coord2d c, float zi) {
        this.x = c.x;
        this.y = c.y;
        this.z = zi;
    }

    public Coord3d(float[] c) {
        this.x = c[0];
        this.y = c[1];
        this.z = c[2];
    }

    public Coord3d(double xi, double yi, double zi) {
        this.x = (float)xi;
        this.y = (float)yi;
        this.z = (float)zi;
    }

    public Coord3d set(Coord3d c2) {
        this.x = c2.x;
        this.y = c2.y;
        this.z = c2.z;
        return this;
    }

    public Coord3d set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Coord3d clone() {
        return new Coord3d(this.x, this.y, this.z);
    }

    public Coord2d getXY() {
        return new Coord2d(this.x, this.y);
    }

    public Coord3d add(Coord3d c2) {
        return new Coord3d(this.x + c2.x, this.y + c2.y, this.z + c2.z);
    }

    public Coord3d add(float x, float y, float z) {
        return new Coord3d(this.x + x, this.y + y, this.z + z);
    }

    public Coord3d addSelf(Coord3d c2) {
        this.x += c2.x;
        this.y += c2.y;
        this.z += c2.z;
        return this;
    }

    public Coord3d add(float value) {
        return new Coord3d(this.x + value, this.y + value, this.z + value);
    }

    public Coord3d addSelf(float value) {
        this.x += value;
        this.y += value;
        this.z += value;
        return this;
    }

    public Coord3d sub(Coord3d c2) {
        return new Coord3d(this.x - c2.x, this.y - c2.y, this.z - c2.z);
    }

    public Coord3d subSelf(Coord3d c2) {
        this.x -= c2.x;
        this.y -= c2.y;
        this.z -= c2.z;
        return this;
    }

    public Coord3d sub(float value) {
        return new Coord3d(this.x - value, this.y - value, this.z - value);
    }

    public Coord3d subSelf(float value) {
        this.x -= value;
        this.y -= value;
        this.z -= value;
        return this;
    }

    public Coord3d mul(Coord3d c2) {
        return new Coord3d(this.x * c2.x, this.y * c2.y, this.z * c2.z);
    }

    public void mulSelf(Coord3d c2) {
        this.x *= c2.x;
        this.y *= c2.y;
        this.z *= c2.z;
    }

    public Coord3d mul(float value) {
        return new Coord3d(this.x * value, this.y * value, this.z * value);
    }

    public Coord3d div(Coord3d c2) {
        return new Coord3d(this.x / c2.x, this.y / c2.y, this.z / c2.z);
    }

    public void divSelf(Coord3d c2) {
        this.x /= c2.x;
        this.y /= c2.y;
        this.z /= c2.z;
    }

    public Coord3d div(float value) {
        return new Coord3d(this.x / value, this.y / value, this.z / value);
    }

    public Coord3d negative() {
        return new Coord3d(-this.x, -this.y, -this.z);
    }

    public Coord3d cartesian() {
        return new Coord3d(Math.cos(this.x) * Math.cos(this.y) * (double)this.z, Math.sin(this.x) * Math.cos(this.y) * (double)this.z, Math.sin(this.y) * (double)this.z);
    }

    public Coord3d polar() {
        double r = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        double d = Math.sqrt(this.x * this.x + this.y * this.y);
        if (d == 0.0 && this.z > 0.0f) {
            return new Coord3d(0.0, 1.5707963267948966, r);
        }
        if (d == 0.0 && this.z <= 0.0f) {
            return new Coord3d(0.0, -1.5707963267948966, r);
        }
        double a = Math.abs((double)this.x / d) < 1.0 ? Math.acos((double)this.x / d) * (double)(this.y > 0.0f ? 1 : -1) : (this.y == 0.0f && this.x > 0.0f ? 0.0 : (this.y == 0.0f && this.x < 0.0f ? Math.PI : 0.0));
        double e = Math.atan((double)this.z / d);
        return new Coord3d(a, e, r);
    }

    public double distance(Coord3d c) {
        return Math.sqrt(Math.pow(this.x - c.x, 2.0) + Math.pow(this.y - c.y, 2.0) + Math.pow(this.z - c.z, 2.0));
    }

    public float magSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Coord3d getNormalizedTo(float len) {
        return this.clone().normalizeTo(len);
    }

    public Coord3d normalizeTo(float len) {
        float mag = (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if (mag > 0.0f) {
            mag = len / mag;
            this.x *= mag;
            this.y *= mag;
            this.z *= mag;
        }
        return this;
    }

    public final float dot(Coord3d v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public final Coord3d interpolateTo(Coord3d v, float f) {
        return new Coord3d(this.x + (v.x - this.x) * f, this.y + (v.y - this.y) * f, this.z + (v.z - this.z) * f);
    }

    public String toString() {
        return "x=" + this.x + " y=" + this.y + " z=" + this.z;
    }

    public float[] toArray() {
        float[] array = new float[]{this.x, this.y, this.z};
        return array;
    }

    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof Coord3d)) {
            return false;
        }
        Coord3d that = (Coord3d)aThat;
        return this.x == that.x && this.y == that.y && this.z == that.z;
    }

    public int hashCode() {
        if (this.fHashCode == 0) {
            this.fHashCode = (int)(this.x * 1.0E8f + this.y * 10000.0f + this.z);
        }
        return this.fHashCode;
    }
}

