/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.Utils;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.primitives.Polygon;
import org.jzy3d.plot3d.rendering.view.Camera;

public class Quad
extends Polygon {
    public void draw(GL2 gl, GLU glu, Camera cam) {
        if (this.transform != null) {
            this.transform.execute(gl);
        }
        if (this.facestatus) {
            gl.glPolygonMode(1032, 6914);
            if (this.wfstatus) {
                gl.glEnable(32823);
                gl.glPolygonOffset(1.0f, 1.0f);
            }
            gl.glBegin(7);
            for (Point p : this.points) {
                if (this.mapper != null) {
                    Color c = this.mapper.getColor(p.xyz);
                    gl.glColor4f(c.r, c.g, c.b, c.a);
                } else {
                    gl.glColor4f(p.rgb.r, p.rgb.g, p.rgb.b, p.rgb.a);
                }
                gl.glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
            }
            gl.glEnd();
            if (this.wfstatus) {
                gl.glDisable(32823);
            }
        }
        if (this.wfstatus) {
            gl.glPolygonMode(1032, 6913);
            gl.glEnable(32823);
            gl.glPolygonOffset(1.0f, 1.0f);
            gl.glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, this.wfcolor.a);
            gl.glLineWidth(this.wfwidth);
            gl.glBegin(7);
            for (Point p : this.points) {
                gl.glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
            }
            gl.glEnd();
            gl.glDisable(32823);
        }
    }

    public void add(Point point) {
        if (this.points.size() == 4) {
            throw new RuntimeException("The Quad allready has 4 points registered");
        }
        super.add(point);
    }

    public double getDistance(Camera camera) {
        return this.getBarycentre().distance(camera.getEye());
    }

    public double getShortestDistance(Camera camera) {
        double min = 3.4028234663852886E38;
        double dist = 0.0;
        for (Point point : this.points) {
            dist = point.getDistance(camera);
            if (!(dist < min)) continue;
            min = dist;
        }
        dist = this.getBarycentre().distance(camera.getEye());
        if (dist < min) {
            min = dist;
        }
        return min;
    }

    public double getLongestDistance(Camera camera) {
        double max = 0.0;
        double dist = 0.0;
        for (Point point : this.points) {
            dist = point.getDistance(camera);
            if (!(dist > max)) continue;
            max = dist;
        }
        return max;
    }

    public String toString(int depth) {
        return Utils.blanks(depth) + "(Quad) #points:" + this.points.size();
    }
}

