/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.selectable;

import java.awt.Polygon;
import java.util.List;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ISingleColorable;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.pipelines.NotImplementedException;
import org.jzy3d.plot3d.primitives.Scatter;
import org.jzy3d.plot3d.primitives.selectable.Selectable;
import org.jzy3d.plot3d.rendering.view.Camera;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectableScatter
extends Scatter
implements ISingleColorable,
Selectable {
    protected boolean[] isHighlighted;
    protected Color highlightColor = Color.RED.clone();
    protected Coord3d[] projection;

    public SelectableScatter(Coord3d[] coordinates, Color[] colors) {
        super(coordinates, colors);
    }

    @Override
    public void draw(GL2 gl, GLU glu, Camera cam) {
        if (this.transform != null) {
            this.transform.execute(gl);
        }
        gl.glPointSize(this.width);
        gl.glBegin(0);
        if (this.colors == null) {
            gl.glColor4f(this.rgb.r, this.rgb.g, this.rgb.b, this.rgb.a);
        }
        if (this.coordinates != null) {
            int k = 0;
            for (Coord3d c : this.coordinates) {
                if (this.colors != null) {
                    if (this.isHighlighted[k]) {
                        gl.glColor4f(this.highlightColor.r, this.highlightColor.g, this.highlightColor.b, this.highlightColor.a);
                    } else {
                        gl.glColor4f(this.colors[k].r, this.colors[k].g, this.colors[k].b, this.colors[k].a);
                    }
                    ++k;
                }
                gl.glVertex3f(c.x, c.y, c.z);
            }
        }
        gl.glEnd();
    }

    @Override
    public void project(GL2 gl, GLU glu, Camera cam) {
        this.projection = cam.modelToScreen(gl, glu, this.getData());
    }

    public Coord3d[] getProjection() {
        return this.projection;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color highlightColor) {
        this.highlightColor = highlightColor;
    }

    public void setHighlighted(int id, boolean value) {
        this.isHighlighted[id] = value;
    }

    public boolean getHighlighted(int id) {
        return this.isHighlighted[id];
    }

    public void resetHighlighting() {
        this.isHighlighted = new boolean[this.coordinates.length];
    }

    @Override
    public void setData(Coord3d[] coordinates) {
        this.coordinates = coordinates;
        this.isHighlighted = new boolean[coordinates.length];
        this.bbox.reset();
        for (Coord3d c : coordinates) {
            this.bbox.add(c);
        }
    }

    @Override
    public Coord3d[] getData() {
        return this.coordinates;
    }

    @Override
    public Polygon getHull2d() {
        throw new NotImplementedException();
    }

    @Override
    public List<Coord3d> getLastProjection() {
        throw new NotImplementedException();
    }
}

