/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.scene;

import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.IGLBindedResource;
import org.jzy3d.plot3d.primitives.selectable.Selectable;
import org.jzy3d.plot3d.rendering.legends.Legend;
import org.jzy3d.plot3d.rendering.ordering.AbstractOrderingStrategy;
import org.jzy3d.plot3d.rendering.ordering.DefaultOrderingStrategy;
import org.jzy3d.plot3d.rendering.scene.Decomposition;
import org.jzy3d.plot3d.rendering.scene.Scene;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.rendering.view.View;
import org.jzy3d.plot3d.transform.Transform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph {
    protected List<AbstractDrawable> components;
    protected Scene scene;
    protected Transform transform;
    protected boolean VERBOSE = false;
    protected AbstractOrderingStrategy strategy;
    protected boolean sort = true;

    public Graph(Scene scene) {
        this(scene, new DefaultOrderingStrategy(), true);
    }

    public Graph(Scene scene, boolean sort) {
        this(scene, new DefaultOrderingStrategy(), sort);
    }

    public Graph(Scene scene, AbstractOrderingStrategy strategy) {
        this(scene, strategy, true);
    }

    public Graph(Scene scene, AbstractOrderingStrategy strategy, boolean sort) {
        this.scene = scene;
        this.strategy = strategy;
        this.sort = sort;
        this.components = new ArrayList<AbstractDrawable>();
    }

    public synchronized void dispose() {
        for (AbstractDrawable c : this.components) {
            if (c == null) continue;
            c.dispose();
        }
        this.components.clear();
        this.scene = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AbstractDrawable drawable, boolean updateViews) {
        Graph graph = this;
        synchronized (graph) {
            this.components.add(drawable);
        }
        if (updateViews) {
            for (View view : this.scene.views) {
                view.updateBounds();
            }
        }
    }

    public void add(AbstractDrawable drawable) {
        this.add(drawable, true);
    }

    public void add(List<? extends AbstractDrawable> drawables, boolean updateViews) {
        for (AbstractDrawable abstractDrawable : drawables) {
            this.add(abstractDrawable, false);
        }
        if (updateViews) {
            for (View view : this.scene.views) {
                view.updateBounds();
            }
        }
    }

    public void add(List<? extends AbstractDrawable> drawables) {
        this.add(drawables, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(AbstractDrawable drawable, boolean updateViews) {
        boolean output = false;
        Graph graph = this;
        synchronized (graph) {
            output = this.components.remove(drawable);
        }
        BoundingBox3d bbox = this.getBounds();
        for (View view : this.scene.views) {
            view.lookToBox(bbox);
            if (!updateViews) continue;
            view.shoot();
        }
        return output;
    }

    public boolean remove(AbstractDrawable drawable) {
        return this.remove(drawable, true);
    }

    public List<AbstractDrawable> getAll() {
        return this.components;
    }

    public synchronized List<IGLBindedResource> getAllGLBindedResources() {
        ArrayList<IGLBindedResource> out = new ArrayList<IGLBindedResource>();
        for (AbstractDrawable c : this.components) {
            if (!(c instanceof IGLBindedResource)) continue;
            out.add((IGLBindedResource)((Object)c));
        }
        return out;
    }

    public void mountAllGLBindedResources(GL2 gl) {
        List<IGLBindedResource> all = this.getAllGLBindedResources();
        for (IGLBindedResource r : all) {
            if (r.hasMountedOnce()) continue;
            r.mount(gl);
        }
    }

    public void draw(GL2 gl, GLU glu, Camera camera) {
        this.draw(gl, glu, camera, this.components, this.sort);
    }

    protected synchronized void draw(GL2 gl, GLU glu, Camera camera, List<AbstractDrawable> components, boolean sort) {
        gl.glMatrixMode(5888);
        if (!sort) {
            for (AbstractDrawable d : components) {
                if (!d.isDisplayed()) continue;
                d.draw(gl, glu, camera);
            }
        } else {
            ArrayList<AbstractDrawable> monotypes = Decomposition.getDecomposition(components);
            this.strategy.sort(monotypes, camera);
            for (AbstractDrawable d : monotypes) {
                if (!d.isDisplayed()) continue;
                d.draw(gl, glu, camera);
            }
        }
    }

    public synchronized void project(GL2 gl, GLU glu, Camera camera) {
        for (AbstractDrawable d : this.components) {
            if (!(d instanceof Selectable)) continue;
            ((Selectable)((Object)d)).project(gl, glu, camera);
        }
    }

    public AbstractOrderingStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(AbstractOrderingStrategy strategy) {
        this.strategy = strategy;
    }

    public synchronized void setTransform(Transform transform) {
        this.transform = transform;
        for (AbstractDrawable c : this.components) {
            if (c == null) continue;
            c.setTransform(transform);
        }
    }

    public Transform getTransform() {
        return this.transform;
    }

    public synchronized BoundingBox3d getBounds() {
        if (this.components.size() == 0) {
            return new BoundingBox3d(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
        BoundingBox3d box = new BoundingBox3d();
        for (AbstractDrawable c : this.components) {
            if (c == null || c.getBounds() == null) continue;
            box.add(c.getBounds());
        }
        return box;
    }

    public synchronized List<Legend> getLegends() {
        ArrayList<Legend> list = new ArrayList<Legend>();
        for (AbstractDrawable c : this.components) {
            if (c == null || !c.hasLegend() || !c.isLegendDisplayed()) continue;
            list.add(c.getLegend());
        }
        return list;
    }

    public synchronized int hasLegends() {
        int k = 0;
        for (AbstractDrawable c : this.components) {
            if (c == null || !c.hasLegend() || !c.isLegendDisplayed()) continue;
            ++k;
        }
        return k;
    }

    public synchronized String toString() {
        String output = "(Graph) #elements:" + this.components.size() + ":\n";
        int k = 0;
        for (AbstractDrawable c : this.components) {
            if (c != null) {
                output = output + " Graph element [" + k++ + "]:" + c.toString(1) + "\n";
                continue;
            }
            output = output + " Graph element [" + k++ + "] (null)\n";
        }
        return output;
    }
}

