/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.textures;

import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureCoords;
import com.jogamp.opengl.util.texture.TextureIO;
import java.io.File;
import java.io.IOException;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLException;
import org.jzy3d.plot3d.primitives.IGLBindedResource;

public class SharedTexture
implements IGLBindedResource {
    protected Texture texture = null;
    protected String file;
    protected TextureCoords coords;
    protected float halfWidth;
    protected float halfHeight;

    protected SharedTexture() {
    }

    public SharedTexture(String file) {
        this.file = file;
    }

    public Texture getTexture(GL2 gl) {
        if (this.texture == null) {
            this.mount(gl);
        }
        return this.texture;
    }

    public void mount(GL2 gl) {
        try {
            this.load(gl, this.file);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.coords = this.texture.getImageTexCoords();
        this.halfWidth = this.texture.getWidth() / 2;
        this.halfHeight = this.texture.getHeight() / 2;
    }

    public boolean hasMountedOnce() {
        return this.texture != null;
    }

    protected void load(GL2 gl, String fileName) throws GLException, IOException {
        this.texture = TextureIO.newTexture((File)new File(fileName), (boolean)false);
        this.texture.setTexParameteri((GL)gl, 10240, 9728);
        this.texture.setTexParameteri((GL)gl, 10241, 9728);
    }

    public String getFile() {
        return this.file;
    }

    public TextureCoords getCoords() {
        return this.coords;
    }

    public float getHalfWidth() {
        return this.halfWidth;
    }

    public float getHalfHeight() {
        return this.halfHeight;
    }
}

