/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataUtilities;
import org.geotools.resources.NIOUtilities;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.logging.Logging;

class MemoryMapCache {
    static final Logger LOGGER = Logging.getLogger(MemoryMapCache.class);
    SoftValueHashMap<MappingKey, MappedByteBuffer> buffers = new SoftValueHashMap(0, (SoftValueHashMap.ValueCleaner)new BufferCleaner());

    MemoryMapCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MappedByteBuffer map(FileChannel wrapped, URL url, FileChannel.MapMode mode, long position, long size) throws IOException {
        if (mode != FileChannel.MapMode.READ_ONLY) {
            return wrapped.map(mode, position, size);
        }
        File file = DataUtilities.urlToFile(url).getCanonicalFile();
        MappingKey mk = new MappingKey(file, position, size);
        MappedByteBuffer buffer = (MappedByteBuffer)this.buffers.get((Object)mk);
        if (buffer == null) {
            MemoryMapCache memoryMapCache = this;
            synchronized (memoryMapCache) {
                buffer = (MappedByteBuffer)this.buffers.get((Object)mk);
                if (buffer == null) {
                    buffer = wrapped.map(mode, position, size);
                    this.buffers.put((Object)mk, (Object)buffer);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Mapping and caching " + file.getAbsolutePath());
                    }
                }
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Using cached map for " + file.getAbsolutePath());
        }
        return (MappedByteBuffer)buffer.duplicate();
    }

    void cleanFileCache(URL url) {
        try {
            File rawFile = DataUtilities.urlToFile(url);
            if (rawFile == null) {
                return;
            }
            File file = rawFile.getCanonicalFile();
            ArrayList keys = new ArrayList(this.buffers.keySet());
            for (MappingKey key : keys) {
                if (!key.file.equals(file)) continue;
                MappedByteBuffer buffer = (MappedByteBuffer)this.buffers.remove((Object)key);
                NIOUtilities.clean((ByteBuffer)buffer, (boolean)true);
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.log(Level.FINE, "Removed mapping for " + file.getAbsolutePath());
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.WARNING, "An error occurred while trying to clean the memory map cache", t);
        }
    }

    void clean() {
        ArrayList keys = new ArrayList(this.buffers.keySet());
        for (MappingKey key : keys) {
            MappedByteBuffer buffer = (MappedByteBuffer)this.buffers.remove((Object)key);
            NIOUtilities.clean((ByteBuffer)buffer, (boolean)true);
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.log(Level.FINE, "Removed mapping for " + key.file.getAbsolutePath());
        }
    }

    public class BufferCleaner
    implements SoftValueHashMap.ValueCleaner {
        public void clean(Object key, Object object) {
            MappedByteBuffer buffer = (MappedByteBuffer)object;
            NIOUtilities.clean((ByteBuffer)buffer, (boolean)true);
        }
    }

    static class MappingKey {
        File file;
        long position;
        long size;

        public MappingKey(File file, long position, long size) {
            this.file = file;
            this.position = position;
            this.size = size;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
            result = 31 * result + (int)(this.position ^ this.position >>> 32);
            result = 31 * result + (int)(this.size ^ this.size >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MappingKey other = (MappingKey)obj;
            if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
                return false;
            }
            if (this.position != other.position) {
                return false;
            }
            return this.size == other.size;
        }
    }
}

