/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model;

import edu.geophys.commons.model.DefaultTraceMetadata;
import edu.geophys.commons.model.TraceData;
import edu.geophys.commons.model.TraceMetadata;
import java.io.Serializable;

public abstract class AbstractTrace
extends DefaultTraceMetadata
implements Serializable,
TraceData {
    private static final long serialVersionUID = 1375657637570948236L;

    public AbstractTrace() {
    }

    public AbstractTrace(TraceMetadata traceMetadata) {
        super(traceMetadata);
        if (traceMetadata == null) {
            throw new IllegalArgumentException("null value not allowed in copy constructor");
        }
    }

    protected abstract float[] _getSamples();

    protected abstract float[] _getSamples(int var1, int var2);

    protected abstract float _getSample(int var1);

    @Override
    public final float[] getSamples() {
        return this._getSamples(0, this.getLength());
    }

    @Override
    public final float[] getSamples(int n, int n2) {
        if (n + n2 > this.getLength() || n < 0 || n2 < 1) {
            throw new IllegalArgumentException("Requested range is not part of this entry.");
        }
        return this._getSamples(n, n2);
    }

    @Override
    public final float[] getSamples(double d, int n) {
        int n2;
        if (!this.contains(d)) {
            throw new IllegalArgumentException("Requested start time is not part of this entry.");
        }
        int n3 = (int)Math.rint((d - this.getStartEpochTime()) / this.getSampleIncrement());
        if (n3 + (n2 = n) > this.getLength()) {
            n2 = this.getLength() - n3;
        }
        float[] fArray = this.getSamples(n3, n2);
        return fArray;
    }

    @Override
    public final float[] getSamples(double d, double d2) {
        if (!this.contains(d2)) {
            throw new IllegalArgumentException("Requested end time is not part of this entry.");
        }
        long l = (long)Math.rint((d2 - d) / this.getSampleIncrement());
        if (l > Integer.MAX_VALUE) {
            throw new ArrayIndexOutOfBoundsException("Requested time range contains more samples than an array could have");
        }
        return this.getSamples(d, (int)l);
    }

    @Override
    public final float getSample(int n) {
        return this._getSample(n);
    }

    @Override
    public final float getSample(double d) {
        if (!this.contains(d)) {
            throw new IllegalArgumentException("Requested start time is not part of this entry.");
        }
        int n = (int)Math.rint((d - this.getStartEpochTime()) / this.getSampleIncrement());
        return this._getSample(n);
    }
}

