/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model;

import edu.geophys.commons.model.AbstractTrace;
import edu.geophys.commons.model.TraceMetadata;
import java.io.Serializable;
import java.util.Arrays;

public final class DefaultTrace
extends AbstractTrace
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -7709412763662439818L;
    private float[] _samples = new float[0];

    public DefaultTrace() {
    }

    public DefaultTrace(TraceMetadata traceMetadata) {
        super(traceMetadata);
    }

    public DefaultTrace(AbstractTrace abstractTrace) {
        super(abstractTrace);
        this.setSamples(abstractTrace.getSamples());
    }

    @Override
    protected final float[] _getSamples() {
        return this._samples;
    }

    @Override
    protected final float[] _getSamples(int n, int n2) {
        return Arrays.copyOfRange(this._samples, n, n + n2);
    }

    @Override
    protected final float _getSample(int n) {
        return this._samples[n];
    }

    public void setSamples(float[] fArray) {
        if (fArray == null) {
            throw new NullPointerException("Input argument must be not null!");
        }
        this._samples = fArray;
        this.setLength(this._samples.length);
    }

    public void setSample(int n, float f) {
        if (n < 0 && n >= this._samples.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this._samples[n] = f;
    }

    @Override
    public String toString() {
        String string = "seismogramm=" + Arrays.toString(this._samples) + ", super=" + super.toString();
        return this.getClass().getName() + "[" + string + "]";
    }

    public DefaultTrace clone() throws CloneNotSupportedException {
        DefaultTrace defaultTrace = new DefaultTrace(this);
        return defaultTrace;
    }

    @Deprecated
    public void setSeismogram(float[] fArray) throws NullPointerException {
        this.setSamples(fArray);
    }

    @Deprecated
    public float[] getSeismogram() {
        return this._samples;
    }
}

