/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model;

import edu.geophys.commons.model.TraceMetadata;
import edu.geophys.commons.util.LogUtil;
import java.io.Serializable;

public class DefaultTraceMetadata
implements Serializable,
TraceMetadata {
    private static final long serialVersionUID = 1275657067170908566L;
    private String _stationName = "";
    private String _stationChannel = "";
    private boolean _isCentralStation;
    private double _startEpochTime = 0.0;
    private float _samplerate = 0.0f;
    private float _originalSamplerate = 0.0f;
    private int _length = 0;
    private int _originalLength = 0;
    private float _calibration = 0.0f;
    private int _lsbFactor = 0;

    public DefaultTraceMetadata() {
    }

    public DefaultTraceMetadata(TraceMetadata traceMetadata) {
        this.shallowCopyFrom(traceMetadata);
    }

    @Override
    public String getStationName() {
        return this._stationName;
    }

    @Override
    public String getStationChannel() {
        return this._stationChannel;
    }

    @Override
    public final String getStationID() {
        return this.getStationName() + "-" + this.getStationChannel();
    }

    @Override
    public final double getStartEpochTime() {
        return this._startEpochTime;
    }

    @Override
    public double getEndEpochTime() {
        return this.getStartEpochTime() + (double)(this.getLength() - 1) * this.getSampleIncrement();
    }

    @Override
    public final double getSampleIncrement() {
        return 1.0 / (double)this.getSamplerate();
    }

    @Override
    public final float getSamplerate() {
        return this._samplerate;
    }

    @Override
    public final float getOriginalSamplerate() {
        return this._originalSamplerate;
    }

    @Override
    public int getLength() {
        return this._length;
    }

    @Override
    public int getOriginalLength() {
        return this._originalLength;
    }

    @Override
    public final float getCalibration() {
        return this._calibration;
    }

    @Override
    public final int getLsbFactor() {
        return this._lsbFactor;
    }

    @Override
    public final boolean contains(double d) {
        return d >= this.getStartEpochTime() && d < this.getEndEpochTime();
    }

    public void setStationName(String string) throws IllegalArgumentException {
        if (string == null) {
            LogUtil.error(this.getClass(), "stationName cannot be null", false);
            throw new IllegalArgumentException("stationName cannot be null");
        }
        if (string.length() <= 0) {
            LogUtil.error(this.getClass(), "stationName cannot be the empty string", false);
            throw new IllegalArgumentException("stationName cannot be the empty string");
        }
        this._stationName = string;
    }

    public void setStationChannel(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("stationChannel cannot be null");
        }
        if (string.length() <= 0) {
            throw new IllegalArgumentException("stationChannel cannot be the empty string");
        }
        this._stationChannel = string;
    }

    public void setStartEpochTime(double d) {
        this._startEpochTime = d;
    }

    public void setSamplerate(float f) {
        this._samplerate = f;
    }

    public void setOriginalSamplerate(float f) {
        this._originalSamplerate = f;
    }

    public void setLength(int n) {
        this._length = n;
    }

    public void setOriginalLength(int n) {
        this._originalLength = n;
    }

    public void setCalibration(float f) {
        this._calibration = f;
    }

    public void setLsbFactor(int n) {
        this._lsbFactor = n;
    }

    protected final void shallowCopyFrom(TraceMetadata traceMetadata) throws IllegalArgumentException {
        if (traceMetadata == null) {
            throw new IllegalArgumentException("not possible to copy from null");
        }
        this.setStationName(traceMetadata.getStationName());
        this.setStationChannel(traceMetadata.getStationChannel());
        this.setStartEpochTime(traceMetadata.getStartEpochTime());
        this.setSamplerate(traceMetadata.getSamplerate());
        this.setLength(traceMetadata.getLength());
        this.setOriginalSamplerate(traceMetadata.getOriginalSamplerate());
        this.setOriginalLength(traceMetadata.getOriginalLength());
        this.setCalibration(traceMetadata.getCalibration());
        this.setLsbFactor(traceMetadata.getLsbFactor());
    }

    public String toString() {
        String string = "stationName=" + this._stationName + ", stationChannel=" + this._stationChannel + ", epochTime=" + this._startEpochTime + ", length=" + this._length + ", samplerate=" + this._samplerate + ", calibration=" + this._calibration + ", lsbFactor=" + this._lsbFactor + ", super=" + super.toString();
        return this.getClass().getName() + "[" + string + "]";
    }
}

