/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model.headerfiles;

import edu.geophys.commons.model.tracefiles.AbstractTraceFile;
import edu.geophys.commons.model.tracefiles.NativeDataType;
import edu.geophys.commons.model.tracefiles.TraceFileMetadata;
import edu.geophys.commons.util.LogUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractHeaderReader
extends BufferedReader {
    private static final String ARGUMENT_SHORT = "Argument to short: ";
    private static final String ARGUMENT_NULL = "Argument could not be null: ";
    private static final String ARGUMENT_INVALID_FLOAT = "Argument is not a valid float: ";
    private static final String ARGUMENT_INVALID_DOUBLE = "Argument is not a valid double: ";
    private static final String ARGUMENT_INVALID_INT = "Argument is not a valid integer: ";
    private static final String ARGUMENT_INVALID_DATATYPE = "Argument is not a known data type: ";
    private static final String ARGUMENT_INVALID_FILE = "File does not exist: ";
    private int linecounter = 0;
    protected final File _headerFile;

    protected static final AbstractTraceFile createEntryChecked(File file, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12) throws IllegalArgumentException {
        long l;
        NativeDataType nativeDataType;
        float f;
        float f2;
        float f3;
        int n;
        double d;
        TraceFileMetadata traceFileMetadata = new TraceFileMetadata();
        if (string == null) {
            throw new IllegalArgumentException("Argument could not be null: stat");
        }
        if (string.length() <= 0) {
            throw new IllegalArgumentException("Argument to short: stat (" + string + ")");
        }
        traceFileMetadata.setStationName(string);
        if (string2 == null) {
            throw new IllegalArgumentException("Argument could not be null: chan");
        }
        if (string2.length() <= 0) {
            throw new IllegalArgumentException("Argument to short: chan (" + string2 + ")");
        }
        traceFileMetadata.setStationChannel(string2);
        if (string3 == null) {
            throw new IllegalArgumentException("Argument could not be null: epoch");
        }
        try {
            d = Double.parseDouble(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Argument is not a valid double: epoch (" + string3 + ")");
        }
        traceFileMetadata.setStartEpochTime(d);
        if (string4 == null) {
            throw new IllegalArgumentException("Argument could not be null: nsamp");
        }
        try {
            n = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Argument is not a valid integer: nsamp (" + string4 + ")");
        }
        traceFileMetadata.setLength(n);
        if (string5 == null) {
            throw new IllegalArgumentException("Argument could not be null: samprate");
        }
        try {
            f3 = Float.parseFloat(string5);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Argument is not a valid float: samprate (" + string5 + ")");
        }
        traceFileMetadata.setSamplerate(f3);
        if (string6 == null) {
            throw new IllegalArgumentException("Argument could not be null: calibm");
        }
        try {
            f2 = Float.parseFloat(string6);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Argument is not a valid float: calibm (" + string6 + ")");
        }
        if (string7 == null) {
            throw new IllegalArgumentException("Argument could not be null: calper");
        }
        try {
            f = Float.parseFloat(string7);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Argument is not a valid float: calper (" + string7 + ")");
        }
        if (Float.compare(f2, 0.0f) != 0 && Float.compare(f, 0.0f) != 0) {
            float f4 = f2 * ((float)Math.PI * 2) / f;
            if (f4 < 0.0f) {
                f4 = 1.0f;
                LogUtil.error(AbstractHeaderReader.class, "Calibration factor can not be smaller 0.0, set to 1.0");
            }
            traceFileMetadata.setCalibration(f4);
        } else {
            LogUtil.error(AbstractHeaderReader.class, "Calibration factor can not be 0.0, set to 1.0");
            traceFileMetadata.setCalibration(1.0f);
        }
        if (string12 != null) {
            try {
                int n2 = Integer.parseInt(string12);
                traceFileMetadata.setCalibration(traceFileMetadata.getCalibration() * (float)n2);
                traceFileMetadata.setLsbFactor(n2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Argument is not a valid float: lsbfak (" + string12 + ")");
            }
        } else {
            int n3 = 1;
            traceFileMetadata.setLsbFactor(n3);
        }
        if (string8 == null) {
            throw new IllegalArgumentException("Argument could not be null: dattyp");
        }
        try {
            nativeDataType = NativeDataType.valueOf(string8.toLowerCase());
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalArgumentException("Argument is not a known data type: dattyp", runtimeException.getCause());
        }
        if (string11 == null) {
            throw new IllegalArgumentException("Argument could not be null: byteOffset");
        }
        try {
            l = Long.valueOf(string11);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Argument is not a valid integer: byteOffset (" + string11 + ")");
        }
        if (string9 == null) {
            throw new IllegalArgumentException("Argument could not be null: directory");
        }
        if (string9.length() <= 0) {
            throw new IllegalArgumentException("Argument to short: directory");
        }
        File file2 = string9.startsWith(".\\") || string9.startsWith("\\") || string9.startsWith("./") ? new File(file.getParent() + File.separator + new File(string9.substring(2).replace("\\", File.separator)).getPath()) : new File(new File(string9.replace("\\", File.separator)).getPath());
        if (string10 == null) {
            throw new IllegalArgumentException("Argument could not be null: filename");
        }
        if (string10.length() <= 0) {
            throw new IllegalArgumentException("Argument to short: filename");
        }
        File file3 = new File(file2.getAbsolutePath() + File.separator + string10);
        if (!file3.exists()) {
            throw new IllegalArgumentException(ARGUMENT_INVALID_FILE + file3);
        }
        traceFileMetadata.setOriginalSamplerate(traceFileMetadata.getSamplerate());
        traceFileMetadata.setOriginalLength(traceFileMetadata.getLength());
        traceFileMetadata.setTraceDataFile(file3);
        traceFileMetadata.setByteOffset(l);
        traceFileMetadata.setDataType(nativeDataType);
        return traceFileMetadata.createNativeFileInstance();
    }

    protected static final AbstractTraceFile createEntryChecked(File file, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11) {
        return AbstractHeaderReader.createEntryChecked(file, string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, null);
    }

    protected AbstractHeaderReader(File file) throws FileNotFoundException {
        super(new FileReader(file));
        this._headerFile = file;
    }

    public final LinkedList<AbstractTraceFile> readNextEntry() throws IOException {
        String string;
        LinkedList<AbstractTraceFile> linkedList = new LinkedList<AbstractTraceFile>();
        while ((string = this.readLine()) != null) {
            linkedList = this._parseLine(string, this.linecounter + 1);
            ++this.linecounter;
            if (linkedList == null) continue;
        }
        if (linkedList == null) {
            linkedList = new LinkedList();
        } else if (linkedList.size() == 0) {
            linkedList = null;
        }
        return linkedList;
    }

    public final List<AbstractTraceFile> readAllEntries() throws IOException {
        LinkedList<AbstractTraceFile> linkedList;
        LinkedList<AbstractTraceFile> linkedList2 = new LinkedList<AbstractTraceFile>();
        while ((linkedList = this.readNextEntry()) != null) {
            linkedList2.addAll(linkedList);
        }
        if (linkedList2.isEmpty()) {
            LogUtil.fatal(this.getClass(), "Header file is either empty or has no supported entries.", false);
        }
        return linkedList2;
    }

    protected abstract LinkedList<AbstractTraceFile> _parseLine(String var1, int var2);
}

