/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model.headerfiles;

import edu.geophys.commons.model.DefaultTrace;
import edu.geophys.commons.model.ResamplingTrace;
import edu.geophys.commons.model.TraceMetadata;
import edu.geophys.commons.model.headerfiles.HeaderImportHelper;
import edu.geophys.commons.model.tracefiles.AbstractTraceFile;
import edu.geophys.commons.model.tracefiles.MergingTraceFileDatabase;
import edu.geophys.commons.model.tracefiles.TraceFileMetadata;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.DynamicHeaderEntryUtil;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.MemoryUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

@Deprecated
public class HeaderDatabase {
    private final Map<File, List<AbstractTraceFile>> _headerDB = new LinkedHashMap<File, List<AbstractTraceFile>>();
    private final Map<String, MergingTraceFileDatabase> _stationDB = new LinkedHashMap<String, MergingTraceFileDatabase>();
    private final Map<String, List<AbstractTraceFile>> _stationDBDynamic = new LinkedHashMap<String, List<AbstractTraceFile>>();

    public void addHeader(File file) {
        List<AbstractTraceFile> list = HeaderImportHelper.importHeader(file);
        if (list != null) {
            for (AbstractTraceFile abstractTraceFile : list) {
                boolean bl;
                String string = abstractTraceFile.getStationID();
                boolean bl2 = bl = abstractTraceFile.getDynamic() != TraceFileMetadata.DynamicEntryType.STATIC;
                if (!this._stationDB.containsKey(string)) {
                    this._stationDB.put(string, new MergingTraceFileDatabase());
                    this._stationDBDynamic.put(string, new LinkedList());
                }
                if (bl) {
                    if (!this._stationDBDynamic.containsKey(string)) {
                        this._stationDBDynamic.put(string, new LinkedList());
                    }
                    this._stationDBDynamic.get(string).add(abstractTraceFile);
                    continue;
                }
                this._stationDB.get(string).add(abstractTraceFile);
                if (!this._stationDB.containsKey(string)) {
                    this._stationDB.put(string, new MergingTraceFileDatabase());
                }
                this._stationDB.get(string).add(abstractTraceFile);
            }
            this._headerDB.put(file, list);
        }
    }

    public void removeHeader(File file) {
        if (this._headerDB.containsKey(file)) {
            this._headerDB.remove(file);
            this.freeEmptyStations();
        }
    }

    protected void freeEmptyStations() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string : this._stationDB.keySet()) {
            if (!this._stationDB.get(string).isEmpty() || !this._stationDBDynamic.get(string).isEmpty()) continue;
            linkedList.add(string);
        }
        for (String string : linkedList) {
            this._stationDB.remove(string);
            this._stationDBDynamic.remove(string);
        }
    }

    public boolean writeHeader(File file, List<AbstractTraceFile> list) {
        if (!file.exists()) {
            System.out.println("doesnt exist");
            return false;
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            for (AbstractTraceFile abstractTraceFile : list) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
                calendar.setTimeInMillis((long)abstractTraceFile.getStartEpochTime() * 1000L);
                String string = "" + calendar.get(1) + calendar.get(6);
                DecimalFormat decimalFormat = new DecimalFormat("0.000", DecimalFormatSymbols.getInstance(Locale.US));
                String string2 = decimalFormat.format(abstractTraceFile.getStartEpochTime());
                String string3 = string + "\t" + string2 + "\t" + abstractTraceFile.getStationName() + "\t" + abstractTraceFile.getStationChannel() + "\t" + abstractTraceFile.getOriginalLength() + "\t" + abstractTraceFile.getOriginalSamplerate() + "\t" + abstractTraceFile.getCalibration() / ((float)Math.PI * 2) + "\t1.0\t" + abstractTraceFile.getDataType() + "\t" + abstractTraceFile.getTraceDataFile().getParent() + "\t" + abstractTraceFile.getTraceDataFile().getName() + "\t" + abstractTraceFile.getByteOffset() + "\t";
                bufferedWriter.write(string3);
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
            return true;
        }
        catch (IOException iOException) {
            LogUtil.error(this.getClass(), iOException.getMessage(), false);
            iOException.printStackTrace();
            return false;
        }
    }

    public File[] listHeaders() {
        return this._headerDB.keySet().toArray(new File[this._headerDB.keySet().size()]);
    }

    public int sizeHeaders() {
        return this._headerDB.size();
    }

    public String[] listTraces() {
        Set<String> set = this._stationDB.keySet();
        Set<String> set2 = this._stationDBDynamic.keySet();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(set);
        hashSet.addAll(set2);
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public boolean hasStation(String string) {
        return this._stationDB.containsKey(string) || this._stationDBDynamic.containsKey(string);
    }

    public int sizeStations() {
        return this.listTraces().length;
    }

    public TraceMetadata getMetadata(String string) {
        MergingTraceFileDatabase mergingTraceFileDatabase;
        if (this.hasStation(string)) {
            mergingTraceFileDatabase = this._stationDB.get(string).shallowCopy();
            for (AbstractTraceFile abstractTraceFile : this._stationDBDynamic.get(string)) {
                mergingTraceFileDatabase.add(abstractTraceFile);
            }
            assert (!mergingTraceFileDatabase.isEmpty()) : mergingTraceFileDatabase;
        } else {
            LogUtil.error(this.getClass(), "station not available (check station knowbase for empty values):" + string, false);
            throw new IllegalArgumentException("station not available (check station knowbase for empty values):" + string);
        }
        MergingTraceFileDatabase mergingTraceFileDatabase2 = mergingTraceFileDatabase;
        return mergingTraceFileDatabase2;
    }

    private DefaultTrace getTrace(String string, double d, double d2) {
        DefaultTrace defaultTrace;
        this.clearCache();
        if (this.hasStation(string)) {
            MergingTraceFileDatabase mergingTraceFileDatabase = this._stationDB.get(string).shallowCopy();
            for (AbstractTraceFile abstractTraceFile : this._stationDBDynamic.get(string)) {
                List<AbstractTraceFile> list = DynamicHeaderEntryUtil.defineFullEntries(abstractTraceFile, d, d2);
                for (AbstractTraceFile abstractTraceFile2 : list) {
                    mergingTraceFileDatabase.add(abstractTraceFile2);
                }
            }
            if (mergingTraceFileDatabase.isEmpty()) {
                for (AbstractTraceFile abstractTraceFile : this._stationDBDynamic.get(string)) {
                    mergingTraceFileDatabase.add(DynamicHeaderEntryUtil.firstMatch(abstractTraceFile));
                }
            }
            try {
                defaultTrace = mergingTraceFileDatabase.getMergedTrace(d, d2);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                LogUtil.fatal(this.getClass(), "application run out of memory while reading seismic data", outOfMemoryError);
                throw (OutOfMemoryError)outOfMemoryError.fillInStackTrace();
            }
        } else {
            LogUtil.error(this.getClass(), "station not available (check station knowbase for empty values):" + string, false);
            throw new IllegalArgumentException("station not available (check station knowbase for empty values):" + string);
        }
        return defaultTrace;
    }

    public DefaultTrace getTrace(String string, double d, int n, float f) {
        double d2 = d + (double)n * (1.0 / (double)f);
        return this.getTrace(string, d, d2, f);
    }

    public DefaultTrace getTrace(String string, double d, double d2, float f) {
        DefaultTrace defaultTrace = this.getTrace(string, d, d2);
        ResamplingTrace resamplingTrace = new ResamplingTrace(defaultTrace);
        resamplingTrace.resample(f);
        DefaultTrace defaultTrace2 = new DefaultTrace(resamplingTrace);
        return defaultTrace2;
    }

    public double getEndOfStationData(String string) {
        if (this._stationDB.containsKey(string)) {
            return this._stationDB.get(string).getEndEpochTime();
        }
        return -1.0;
    }

    public double getStartOfStationData(String string) {
        if (this._stationDB.containsKey(string)) {
            return this._stationDB.get(string).getStartEpochTime();
        }
        return -1.0;
    }

    public void clearCache() {
        block6: {
            if (!MemoryUtil.memoryExceedsLimit()) break block6;
            long l = SuiteManager.INSTANCE.getSonoViewTimeModel().getValue();
            long l2 = SuiteManager.INSTANCE.getSonoViewTimeModel().getExtent();
            long l3 = l + l2;
            if (l > 0L && l2 > 0L) {
                LogUtil.debug(this.getClass(), "Clear cache: " + DateTimeUtil.formatDateTimeISO(l) + " " + DateTimeUtil.formatDateTimeISO(l3));
                for (List<AbstractTraceFile> list : this._headerDB.values()) {
                    for (AbstractTraceFile abstractTraceFile : list) {
                        abstractTraceFile.clearCache(l, l3);
                    }
                }
            } else {
                for (List<AbstractTraceFile> list : this._headerDB.values()) {
                    for (AbstractTraceFile abstractTraceFile : list) {
                        abstractTraceFile.getCache().clear();
                    }
                }
            }
        }
    }
}

