/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model.knowledgebase;

import edu.geophys.commons.model.layer.Layer;
import edu.geophys.commons.model.layer.LayerModel;
import edu.geophys.commons.util.LogUtil;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LayerKnowledge {
    private static final String LAYER_RELATIVE_PATH = "layer";
    private static final Pattern FN_NUMBER_REGEX = Pattern.compile("^(\\d+)_");
    private final File path;
    private final ArrayList<LayerModel> layerModels = new ArrayList(10);

    protected LayerKnowledge(File file) {
        this.path = new File(file, LAYER_RELATIVE_PATH);
    }

    public boolean load() {
        if (!this.path.exists()) {
            return false;
        }
        Object[] objectArray = this.path.listFiles();
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            LayerModel layerModel;
            try {
                layerModel = LayerModel.fromCsv(((File)object).getAbsolutePath());
            }
            catch (IOException | NumberFormatException | ParseException exception) {
                LogUtil.warn(this.getClass(), "Error while reading LayerModel:\n" + ((File)object).getPath() + "\n" + exception.getMessage(), true);
                continue;
            }
            if (!layerModel.isValid()) {
                LogUtil.warn(this.getClass(), layerModel.getFile().getPath() + " contains errors:\n" + String.join((CharSequence)"\n", layerModel.getProblems()), true);
            }
            this.layerModels.add(layerModel);
        }
        return !this.layerModels.isEmpty();
    }

    public void store(boolean bl) {
        Object object;
        int n = 0;
        LinkedList<LayerModel> linkedList = new LinkedList<LayerModel>();
        for (LayerModel layerModel : this.layerModels) {
            object = layerModel.getFile();
            if (object == null) {
                linkedList.add(layerModel);
                continue;
            }
            try {
                if (layerModel.isModified() || bl) {
                    layerModel.setModified(false);
                    layerModel.writeCsv(((File)object).getPath());
                }
                n = this.incrementModelCount(n, (File)object);
            }
            catch (IOException iOException) {
                LogUtil.fatal(this.getClass(), "Failed to store LayerModel to file (" + (File)object + ")", true);
            }
        }
        for (LayerModel layerModel : linkedList) {
            object = String.format("%02d_%s", n, layerModel.composeDefaultFilename());
            File file = new File(this.path, (String)object);
            try {
                layerModel.setModified(false);
                layerModel.writeCsv(file.getPath());
                layerModel.setFile(file);
                ++n;
            }
            catch (IOException iOException) {
                LogUtil.fatal(this.getClass(), "Failed to store LayerModel to file (" + file + ")", iOException);
            }
        }
    }

    private int incrementModelCount(int n, File file) {
        int n2 = n;
        Matcher matcher = FN_NUMBER_REGEX.matcher(file.getName());
        if (matcher.find()) {
            n2 = Integer.parseInt(matcher.group(1));
        }
        return n2 + 1;
    }

    protected String getRelativePath() {
        return LAYER_RELATIVE_PATH;
    }

    public void createDefault() {
        ArrayList<LayerModel> arrayList = new ArrayList<LayerModel>();
        ArrayList<Layer> arrayList2 = new ArrayList<Layer>();
        arrayList2.add(new Layer(-1.0, 3.0, -1.0, Layer.WaveType.Unknown));
        arrayList.add(new LayerModel("halfspace", Math.sqrt(3.0), arrayList2));
        arrayList2.clear();
        arrayList2.add(new Layer(3.0, 3.0, -1.0, Layer.WaveType.Unknown));
        arrayList2.add(new Layer(-1.0, 6.0, -1.0, Layer.WaveType.Pg));
        arrayList.add(new LayerModel("1-layer", Math.sqrt(3.0), arrayList2));
        arrayList2.clear();
        arrayList2.add(new Layer(20.0, 5.8, -1.0, Layer.WaveType.Pg));
        arrayList2.add(new Layer(15.0, 6.5, -1.0, Layer.WaveType.Unknown));
        arrayList2.add(new Layer(-1.0, 8.04, -1.0, Layer.WaveType.Pn));
        arrayList.add(new LayerModel("IASPEI", Math.sqrt(3.0), arrayList2));
        arrayList2.clear();
        arrayList2.add(new Layer(5.5, 4.0, -1.0, Layer.WaveType.Unknown));
        arrayList2.add(new Layer(6.5, 5.9, -1.0, Layer.WaveType.Pg));
        arrayList2.add(new Layer(8.0, 6.2, -1.0, Layer.WaveType.Unknown));
        arrayList2.add(new Layer(10.0, 7.0, -1.0, Layer.WaveType.Unknown));
        arrayList2.add(new Layer(-1.0, 8.0, -1.0, Layer.WaveType.Pn));
        arrayList.add(new LayerModel("NorthernGermany 1.78", 1.78, arrayList2));
        arrayList2.clear();
        this.layerModels.addAll(arrayList);
    }

    public File getPath() {
        return this.path;
    }

    public LayerModel[] getLayerModelsArray() {
        LayerModel[] layerModelArray = new LayerModel[this.layerModels.size()];
        return this.layerModels.toArray(layerModelArray);
    }

    public ArrayList<LayerModel> getLayerModels() {
        return this.layerModels;
    }

    public void createNewLayermodel() {
        LayerModel layerModel = new LayerModel();
        layerModel.setModified(true);
        while (this.checkNameAlreadyExists(layerModel)) {
            layerModel.setName(LayerKnowledge.increaseNameNumeral(layerModel.getName()));
        }
        this.layerModels.add(layerModel);
    }

    public boolean checkNameAlreadyExists(LayerModel layerModel) {
        String string = layerModel.getName();
        for (LayerModel layerModel2 : this.layerModels) {
            if (!layerModel2.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private static String increaseNameNumeral(String string) {
        Pattern pattern = Pattern.compile("(.*)\\(([0-9])+\\)$");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            int n = Integer.parseInt(matcher.group(2)) + 1;
            return string2 + "(" + n + ")";
        }
        return string + " (1)";
    }

    public void cloneLayermodel(int n) {
        if (n < 0 || n >= this.layerModels.size()) {
            return;
        }
        LayerModel layerModel = this.layerModels.get(n).clone(false);
        layerModel.setName(LayerKnowledge.increaseNameNumeral(layerModel.getName()));
        layerModel.setModified(true);
        this.layerModels.add(layerModel);
    }

    public void deleteModel(int n) {
        if (n < 0 || n >= this.layerModels.size()) {
            return;
        }
        File file = this.layerModels.get(n).getFile();
        if (file != null && file.exists()) {
            file.delete();
        }
        this.layerModels.remove(n);
    }
}

