/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model.knowledgebase;

import edu.geophys.commons.model.SNS;
import edu.geophys.commons.model.Site;
import edu.geophys.commons.model.TraceMetadata;
import edu.geophys.commons.model.knowledgebase.AbstractKnowledge;
import edu.geophys.commons.suite.SuiteManager;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@XmlRootElement(name="stations")
@XmlType(name="StationsKnowledge")
public class StationsKnowledge
extends AbstractKnowledge<StationsKnowledge> {
    private static final long serialVersionUID = -53851532253153202L;
    private static final String STATION_RELATIVE_FILENAME = "stations.xml";
    private final Map<String, SNS> arrayMap = new LinkedHashMap<String, SNS>();

    public StationsKnowledge() {
        this(null);
    }

    public StationsKnowledge(File file) {
        super(StationsKnowledge.class, file);
    }

    @Override
    protected String getRelativeFilename() {
        return STATION_RELATIVE_FILENAME;
    }

    @Override
    public void setValues(StationsKnowledge stationsKnowledge) {
        this.setAllSNS(stationsKnowledge.getAllSNS());
    }

    @Override
    public void setValuesByValue(StationsKnowledge stationsKnowledge) {
        ArrayList<SNS> arrayList = new ArrayList<SNS>();
        for (SNS sNS : stationsKnowledge.getAllSNS()) {
            arrayList.add(sNS.clone());
        }
        this.setAllSNS(arrayList.toArray(new SNS[arrayList.size()]));
    }

    @XmlElement(name="sns", required=true)
    public SNS[] getAllSNS() {
        SNS[] sNSArray = new ArrayList<SNS>(this.arrayMap.values()).toArray(new SNS[this.arrayMap.size()]);
        return sNSArray;
    }

    public SNS[] getAllActiveSNS() {
        ArrayList<SNS> arrayList = new ArrayList<SNS>();
        for (SNS sNS : this.arrayMap.values()) {
            if (!sNS.isEnabled()) continue;
            arrayList.add(sNS);
        }
        SNS[] sNSArray = arrayList.toArray(new SNS[arrayList.size()]);
        return sNSArray;
    }

    public void setAllSNS(SNS[] sNSArray) {
        this.arrayMap.clear();
        for (SNS sNS : sNSArray) {
            this.arrayMap.put(sNS.getID(), sNS);
        }
    }

    public void setAllSNS(List<SNS> list) {
        this.arrayMap.clear();
        for (SNS sNS : list) {
            this.arrayMap.put(sNS.getID(), sNS);
        }
    }

    public List<Site> getAllSites() {
        ArrayList<Site> arrayList = new ArrayList<Site>();
        for (SNS sNS : this.getAllActiveSNS()) {
            arrayList.addAll(sNS.getAllSites());
        }
        return arrayList;
    }

    public Site getSiteById(String string) {
        for (Site site : this.getAllSites()) {
            if (!site.getId().equals(string)) continue;
            return site;
        }
        return null;
    }

    public SNS getSNSBySiteId(String string) {
        for (SNS sNS : this.getAllActiveSNS()) {
            for (Site site : sNS.getAllSites()) {
                if (!site.getId().equals(string)) continue;
                return sNS;
            }
        }
        return null;
    }

    public SNS getSNSByTraceId(String string) {
        for (SNS sNS : this.getAllActiveSNS()) {
            for (Site site : sNS.getAllSites()) {
                if (string.equals(site.getTraceZ())) {
                    return sNS;
                }
                if (string.equals(site.getTraceEW())) {
                    return sNS;
                }
                if (!string.equals(site.getTraceNS())) continue;
                return sNS;
            }
        }
        return null;
    }

    public SNS getSNSById(String string) {
        return this.arrayMap.get(string);
    }

    @Override
    public void createDefault() {
        ArrayList<SNS> arrayList = new ArrayList<SNS>();
        int n = 1;
        for (TraceMetadata traceMetadata : SuiteManager.INSTANCE.getTraceProvider().requestMetadata(SuiteManager.INSTANCE.getTraceProvider().listTraces())) {
            SNS object = null;
            int n2 = -1;
            Object object2 = "";
            if (traceMetadata.getStationName().matches("S\\d[CWEN]")) {
                n2 = Integer.parseInt("" + traceMetadata.getStationName().charAt(1));
                object2 = "" + traceMetadata.getStationName().charAt(2);
            } else if (traceMetadata.getStationName().matches("S\\d\\d[CWEN]")) {
                n2 = Integer.parseInt("" + traceMetadata.getStationName().charAt(1) + traceMetadata.getStationName().charAt(2));
                object2 = "" + traceMetadata.getStationName().charAt(3);
            }
            if (n2 != -1) {
                for (SNS sNS : arrayList) {
                    if (!sNS.getID().equals("SNS" + n2)) continue;
                    object = sNS;
                    break;
                }
                if (object == null) {
                    object = new SNS();
                    object.setID("SNS" + n2);
                }
                if ("C".equals((String)object2)) {
                    if (object.getCenter() == null) {
                        object.setCenter(new Site());
                        object.getCenter().setId(object.getID() + "-C");
                    }
                    if (traceMetadata.getStationChannel().endsWith("Z")) {
                        object.getCenter().setTraceZ(traceMetadata.getStationID());
                    } else if (traceMetadata.getStationChannel().endsWith("N") || traceMetadata.getStationChannel().endsWith("Y")) {
                        object.getCenter().setTraceNS(traceMetadata.getStationID());
                    } else if (traceMetadata.getStationChannel().endsWith("E") || traceMetadata.getStationChannel().endsWith("X")) {
                        object.getCenter().setTraceEW(traceMetadata.getStationID());
                    }
                } else if ("N".equals((String)object2)) {
                    if (object.getNorth() == null) {
                        object.setNorth(new Site());
                        object.getNorth().setId(object.getID() + "-N");
                    }
                    object.getNorth().setTraceZ(traceMetadata.getStationID());
                } else if ("W".equals((String)object2)) {
                    if (object.getWest() == null) {
                        object.setWest(new Site());
                        object.getWest().setId(object.getID() + "-W");
                    }
                    object.getWest().setTraceZ(traceMetadata.getStationID());
                } else if ("E".equals((String)object2)) {
                    if (object.getEast() == null) {
                        object.setEast(new Site());
                        object.getEast().setId(object.getID() + "-E");
                    }
                    object.getEast().setTraceZ(traceMetadata.getStationID());
                } else if ("A1".equals((String)object2)) {
                    if (object.getAux1() == null) {
                        object.setAux1(new Site());
                        object.getAux1().setId(object.getID() + "-A1");
                    }
                    object.getAux1().setTraceZ(traceMetadata.getStationID());
                } else if ("A2".equals((String)object2)) {
                    if (object.getAux2() == null) {
                        object.setAux2(new Site());
                        object.getAux2().setId(object.getID() + "-A2");
                    }
                    object.getAux2().setTraceZ(traceMetadata.getStationID());
                } else if ("A3".equals((String)object2)) {
                    if (object.getAux3() == null) {
                        object.setAux3(new Site());
                        object.getAux3().setId(object.getID() + "-A3");
                    }
                    object.getAux3().setTraceZ(traceMetadata.getStationID());
                } else if ("A4".equals((String)object2)) {
                    if (object.getAux4() == null) {
                        object.setAux4(new Site());
                        object.getAux4().setId(object.getID() + "-A4");
                    }
                    object.getAux4().setTraceZ(traceMetadata.getStationID());
                } else if ("A5".equals((String)object2)) {
                    if (object.getAux5() == null) {
                        object.setAux5(new Site());
                        object.getAux5().setId(object.getID() + "-A5");
                    }
                    object.getAux5().setTraceZ(traceMetadata.getStationID());
                } else if ("A6".equals((String)object2)) {
                    if (object.getAux6() == null) {
                        object.setAux6(new Site());
                        object.getAux6().setId(object.getID() + "-A6");
                    }
                    object.getAux6().setTraceZ(traceMetadata.getStationID());
                }
            } else {
                boolean bl = false;
                block2: for (SNS sNS : arrayList) {
                    if (sNS.getCenter() == null) continue;
                    for (String string : new String[]{sNS.getCenter().getTraceZ(), sNS.getCenter().getTraceEW(), sNS.getCenter().getTraceNS()}) {
                        if (string == null || !traceMetadata.getStationName().equals(string.split("-")[0])) continue;
                        if (traceMetadata.getStationChannel().endsWith("Z")) {
                            sNS.getCenter().setTraceZ(traceMetadata.getStationID());
                            bl = true;
                            break block2;
                        }
                        if (traceMetadata.getStationChannel().endsWith("N") || traceMetadata.getStationChannel().endsWith("Y")) {
                            sNS.getCenter().setTraceNS(traceMetadata.getStationID());
                            bl = true;
                            break block2;
                        }
                        if (!traceMetadata.getStationChannel().endsWith("E") && !traceMetadata.getStationChannel().endsWith("X")) break block2;
                        sNS.getCenter().setTraceEW(traceMetadata.getStationID());
                        bl = true;
                        break block2;
                    }
                }
                if (!bl) {
                    object = new SNS();
                    object.setID(traceMetadata.getStationName() + "-" + n);
                    ++n;
                    Site site = new Site();
                    site.setId(object.getID() + "-C");
                    if (traceMetadata.getStationChannel().endsWith("N") || traceMetadata.getStationChannel().endsWith("Y")) {
                        site.setTraceNS(traceMetadata.getStationID());
                    } else if (traceMetadata.getStationChannel().endsWith("E") || traceMetadata.getStationChannel().endsWith("X")) {
                        site.setTraceEW(traceMetadata.getStationID());
                    } else {
                        site.setTraceZ(traceMetadata.getStationID());
                    }
                    object.setCenter(site);
                }
            }
            if (object == null) continue;
            arrayList.add(object);
        }
        Collections.sort(arrayList, new Comparator<SNS>(){

            @Override
            public int compare(SNS sNS, SNS sNS2) {
                return sNS.getID().compareTo(sNS2.getID());
            }
        });
        for (SNS sNS : arrayList) {
            sNS.setID(sNS.getID().replaceAll("-\\d+$", ""));
        }
        Object object = "";
        int n3 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!((SNS)arrayList.get(i)).getID().equals(object)) {
                object = ((SNS)arrayList.get(i)).getID();
                n3 = 1;
                continue;
            }
            if (n3 == 1) {
                ((SNS)arrayList.get(i - 1)).setID((String)object + "-" + n3);
            }
            ((SNS)arrayList.get(i)).setID((String)object + "-" + ++n3);
        }
        this.setAllSNS(arrayList.toArray(new SNS[arrayList.size()]));
    }

    public Map<String, SNS> getArrayMap() {
        return this.arrayMap;
    }
}

