/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model.layer;

import edu.geophys.commons.model.layer.Layer;
import edu.geophys.commons.util.Csv;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.PlatformUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class LayerModel {
    public static final String MODIFIED_CHAR = "\u2732";
    private static final String FILE_EXTENSION = ".lml";
    private String name = "default model";
    private String description = "";
    private File file = null;
    private boolean modified = false;
    private double vp2vs = 1.75;
    private double zeroElevation = Double.NaN;
    private final List<Layer> layers = new ArrayList<Layer>(10);
    private List<String> problems;

    public LayerModel() {
        this.layers.add(new Layer());
    }

    public LayerModel(String string, double d, List<Layer> list) {
        this.name = string;
        this.vp2vs = d;
        this.layers.addAll(list);
    }

    public static LayerModel fromCsv(String string) throws IOException, NumberFormatException, ParseException {
        double d;
        LayerModel layerModel = new LayerModel();
        Csv csv = Csv.CSVReader.fromFile(string);
        layerModel.file = new File(string);
        String string2 = csv.getValCaseInsensitive("name");
        String string3 = csv.getValCaseInsensitive("description");
        String string4 = csv.getValCaseInsensitive("vp2vs");
        String string5 = csv.getValCaseInsensitive("zeroElevation");
        if (string2 == null || string2.isBlank()) {
            throw new ParseException("model 'NAME' field not set in " + string, 0);
        }
        layerModel.name = string2;
        if (string3 != null && !string3.isBlank()) {
            layerModel.description = string3;
        }
        if (string4 != null && (d = Double.parseDouble(string4)) >= 1.0) {
            layerModel.vp2vs = d;
        }
        if (string5 != null) {
            layerModel.zeroElevation = Double.parseDouble(string5);
        }
        layerModel.layers.clear();
        for (String[] stringArray : csv.getData()) {
            layerModel.layers.add(Layer.fromCsv(stringArray));
        }
        if (!layerModel.isValid()) {
            LogUtil.error(layerModel.getClass(), "Invalid LayerModel:\n" + String.join((CharSequence)"\n", layerModel.getProblems()), true);
        }
        return layerModel;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public List<Layer> getLayers() {
        return this.layers;
    }

    public String toString() {
        return String.format("%s, vp2vs=%.2f, %d layers", this.name, this.vp2vs, this.layers.size());
    }

    public String toStringFull() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(String.format("Model: %s\nvp2vs = %.2f\nzeroElevation = %.3f km\n%1d layers:", this.name, this.vp2vs, this.zeroElevation, this.layers.size()));
        for (Layer layer : this.layers) {
            linkedList.add(layer.toString());
        }
        return String.join((CharSequence)"\n", linkedList);
    }

    public boolean isValid() {
        if (this.problems == null) {
            this.checkValid();
        }
        return this.problems.size() == 0;
    }

    public void checkValid() {
        this.problems = new LinkedList<String>();
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (this.layers.size() > 10) {
            this.problems.add("layer number is greater than 10");
        }
        double d = -1.0;
        for (Layer layer : this.layers) {
            if (Double.isNaN(layer.getVp()) || layer.getVp() <= 0.0) {
                this.problems.add(String.format("layer %d: vp must be larger than 0", n));
            }
            if (layer.getVp() <= d) {
                this.problems.add(String.format("layer %d: vp must be increasing with depth", n));
            }
            d = layer.getVp();
            if (layer.hasVs()) {
                if (layer.getVs() >= layer.getVp()) {
                    this.problems.add(String.format("layer %d: vs >= vp", n));
                }
            } else {
                bl = true;
            }
            switch (layer.getWavetype()) {
                case Pn: {
                    ++n2;
                    break;
                }
                case Pg: {
                    ++n3;
                    break;
                }
            }
            if (bl2) {
                this.problems.add(String.format("layer %d: layer is below halfspace", n));
            }
            if (layer.isHalfspace()) {
                bl2 = true;
            }
            ++n;
        }
        if (!bl2) {
            this.problems.add("Last layer is not halfspace");
        }
        if (!this.hasGlobalVs2Vp() && bl) {
            this.problems.add("Must set global vp2vs>1 or set vS for each layer");
        }
        if (n2 > 1) {
            this.problems.add("Model contains more than one Pn layer");
        }
        if (n3 > 1) {
            this.problems.add("Model contains more than one Pg layer");
        }
    }

    public boolean hasGlobalVs2Vp() {
        return this.vp2vs > 1.0 && !Double.isNaN(this.vp2vs);
    }

    public List<String> getProblems() {
        if (this.problems == null) {
            this.checkValid();
        }
        return this.problems;
    }

    public double getUpperBound(int n) {
        return this.getUpperBound(n, this.getZeroElevation());
    }

    public double getUpperBound(int n, double d) {
        double d2 = d;
        int n2 = 0;
        for (Layer layer : this.layers) {
            if (n2 == n) break;
            if (layer.getD() < 0.0) {
                return Double.NEGATIVE_INFINITY;
            }
            d2 -= layer.getD();
            ++n2;
        }
        return d2;
    }

    public LayerModel clone() {
        return this.clone(true);
    }

    public LayerModel clone(boolean bl) {
        LayerModel layerModel = new LayerModel();
        layerModel.name = this.name;
        layerModel.vp2vs = this.vp2vs;
        layerModel.description = this.description;
        if (bl) {
            layerModel.file = this.file;
        }
        layerModel.zeroElevation = this.zeroElevation;
        layerModel.layers.clear();
        for (Layer layer : this.layers) {
            layerModel.layers.add(layer.clone());
        }
        return layerModel;
    }

    public void writeCsv(String string) throws IOException {
        FileWriter fileWriter = new FileWriter(string);
        for (String string2 : this.toStringListCSV()) {
            fileWriter.write(string2 + PlatformUtil.getNewLine());
        }
        fileWriter.close();
    }

    public List<String> toStringListCSV() {
        LinkedList<String> linkedList = new LinkedList<String>();
        long l = new Date().getTime();
        linkedList.add("# created by HypoLine on " + DateTimeUtil.formatDateTimeISO(l));
        linkedList.add("name=" + this.name);
        if (this.vp2vs > 1.0) {
            linkedList.add(String.format("vp2vs=%.3f", this.vp2vs));
        }
        if (!this.description.isBlank()) {
            linkedList.add("description=" + this.description);
        }
        if (!Double.isNaN(this.zeroElevation)) {
            linkedList.add(String.format("zeroElevation=%.4f # km", this.zeroElevation));
        }
        linkedList.add("# Thickness [km], vP [km/s], (vS [km/s]), (Wavetype [pn|pg])");
        for (Layer layer : this.layers) {
            linkedList.add(layer.toCsvString());
        }
        return linkedList;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String composeDefaultFilename() {
        String string = this.name.strip();
        string = string.replaceAll("[\\s]+", "_");
        string = string.replaceAll("[^A-Za-z0-9_]", "");
        return string + FILE_EXTENSION;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public double getVp2vs() {
        return this.vp2vs;
    }

    public void setVp2vs(double d) {
        this.vp2vs = d;
    }

    public double getZeroElevation() {
        return this.zeroElevation;
    }

    public void setZeroElevation(double d) {
        this.zeroElevation = d;
    }

    public boolean hasZeroElevation() {
        return !Double.isNaN(this.zeroElevation);
    }

    public Layer getLastLayer() {
        return this.layers.get(this.layers.size() - 1);
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean switchWavetypeToLayer(Layer.WaveType waveType, int n) {
        if (n > this.layers.size()) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer layer = this.layers.get(i);
            if (i == n) {
                if (layer.getWavetype() == waveType) continue;
                layer.setWavetype(waveType);
                bl = true;
                continue;
            }
            if (layer.getWavetype() != waveType) continue;
            layer.setWavetype(Layer.WaveType.Unknown);
            bl = true;
        }
        return bl;
    }

    public boolean uiRemoveLayer(int n) {
        int n2 = this.layers.size();
        if (n2 <= 1 || n >= n2) {
            return false;
        }
        if (n == n2 - 1) {
            this.layers.get(n - 1).setD(-1.0);
        }
        this.layers.remove(n);
        return true;
    }

    public boolean uiInsertLayer(int n) {
        Layer layer;
        int n2 = this.layers.size();
        if (n < 0 || n >= n2) {
            return false;
        }
        Layer layer2 = this.layers.get(n);
        if (n == 0) {
            double d = layer2.hasVs() ? 0.5 * layer2.getVs() : layer2.getVs();
            layer = new Layer(1.0, 0.5 * layer2.getVp(), d, Layer.WaveType.Unknown);
        } else {
            Layer layer3 = this.layers.get(n - 1);
            double d = layer2.hasVs() ? 0.5 * (layer2.getVs() + layer3.getVs()) : layer2.getVs();
            layer = new Layer(1.0, 0.5 * (layer2.getVp() + layer3.getVp()), d, Layer.WaveType.Unknown);
        }
        this.layers.add(n, layer);
        return true;
    }
}

