/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model.tracefiles;

import edu.geophys.commons.model.tracefiles.AbstractTraceFile;
import edu.geophys.commons.model.tracefiles.NativeDataType;
import edu.geophys.commons.model.tracefiles.Steim1;
import edu.geophys.commons.model.tracefiles.Steim2;
import edu.geophys.commons.model.tracefiles.TraceFileMetadata;
import edu.geophys.commons.model.tracefiles.Utility;
import edu.geophys.commons.util.LogUtil;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;

public class MsTraceFile
extends AbstractTraceFile {
    private static final long serialVersionUID = -3794070053334655320L;
    private long lBlockOffsetSave = 0L;
    private long lFirstSampleSave = 0L;
    private double timeSave = 0.0;

    public MsTraceFile(TraceFileMetadata traceFileMetadata) {
        super(traceFileMetadata);
    }

    @Override
    protected final void convertToFloat(ByteBuffer byteBuffer, FloatBuffer floatBuffer) {
    }

    public float getSampleRate(double d, double d2) {
        float f = 10000.0f;
        if (d * d2 != 0.0) {
            f = (float)(Math.pow(Math.abs(d), d / Math.abs(d)) * Math.pow(Math.abs(d2), d2 / Math.abs(d2)));
        }
        return f;
    }

    private double getEpochFromMSEED(byte[] byArray, boolean bl) {
        short s = Utility.bytesToShort(byArray[20], byArray[21], bl);
        short s2 = Utility.bytesToShort(byArray[22], byArray[23], bl);
        int n = Utility.bytesToInt(byArray[24]);
        int n2 = Utility.bytesToInt(byArray[25]);
        int n3 = Utility.bytesToInt(byArray[26]);
        int n4 = Utility.bytesToInt(byArray[28], byArray[29], bl);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        calendar.set(1, s);
        calendar.set(6, s2);
        calendar.set(11, n);
        calendar.set(12, n2);
        calendar.set(13, n3);
        calendar.set(14, n4 / 10);
        return (double)calendar.getTimeInMillis() / 1000.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(FloatBuffer floatBuffer, long l) {
        int n = this.getDataType().byteSize;
        long l2 = floatBuffer.remaining();
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        double d = 0.0;
        double d2 = 0.0;
        byte[] byArray = new byte[64];
        boolean bl = this.getDataType().byteOrder.equals(ByteOrder.LITTLE_ENDIAN);
        RandomAccessFile randomAccessFile = null;
        try {
            float f;
            randomAccessFile = new RandomAccessFile(this.getTraceDataFile(), "r");
            boolean bl2 = false;
            if (!bl2) {
                l4 = this.getByteOffset();
                randomAccessFile.seek(l4);
                randomAccessFile.readFully(byArray);
                d = this.getEpochFromMSEED(byArray, bl);
                l5 = Utility.bytesToShort(byArray[30], byArray[31], bl);
                f = this.getSampleRate(Utility.bytesToShort(byArray[32], byArray[33], bl), Utility.bytesToShort(byArray[34], byArray[35], bl));
                l3 = l5;
                d2 = d + (double)l5 / (double)f;
            }
            while (l3 < l) {
                randomAccessFile.seek(l4 += (long)n);
                randomAccessFile.readFully(byArray);
                d = this.getEpochFromMSEED(byArray, bl);
                l5 = Utility.bytesToShort(byArray[30], byArray[31], bl);
                f = this.getSampleRate(Utility.bytesToShort(byArray[32], byArray[33], bl), Utility.bytesToShort(byArray[34], byArray[35], bl));
                if (d < d2 - 0.001) {
                    LogUtil.debug(this.getClass(), "No increasing order in reading of miniSEED blocks");
                    continue;
                }
                if (d > d2 + 0.001) {
                    l3 += (long)((d - d2) * (double)f);
                }
                l3 += l5;
                d2 = d + (double)l5 / (double)f;
            }
            this.lBlockOffsetSave = l4;
            this.lFirstSampleSave = l3 - l5;
            this.timeSave = d;
            l4 -= (long)n;
            l3 -= l5;
            d2 = d;
            byte[] byArray2 = new byte[n - byArray.length];
            while (l3 < l2 + l) {
                long l6;
                randomAccessFile.seek(l4 += (long)n);
                randomAccessFile.readFully(byArray);
                d = this.getEpochFromMSEED(byArray, bl);
                l5 = Utility.bytesToShort(byArray[30], byArray[31], bl);
                f = this.getSampleRate(Utility.bytesToShort(byArray[32], byArray[33], bl), Utility.bytesToShort(byArray[34], byArray[35], bl));
                if (d < d2 - 0.001 || d >= this.getEndEpochTime()) continue;
                long l7 = 0L;
                if (d > d2 + 1.0 / (double)f) {
                    l7 = (long)((d - d2) * (double)f) - 1L;
                    long l8 = floatBuffer.capacity() - floatBuffer.position();
                    l7 = Math.min(l7, l8);
                    l3 += l7;
                    int n2 = 0;
                    while ((long)n2 < l7) {
                        floatBuffer.put(Float.NaN);
                        ++n2;
                    }
                }
                l3 += l5;
                d2 = d + (double)l5 / (double)f;
                randomAccessFile.readFully(byArray2);
                List<Object> list = new ArrayList();
                if (this.getDataType().compression.equals((Object)NativeDataType.CompressionFormat.STEIM1)) {
                    list = Steim1.decode(byArray2, bl);
                } else if (this.getDataType().compression.equals((Object)NativeDataType.CompressionFormat.STEIM2)) {
                    list = Steim2.decode(byArray2, bl);
                } else {
                    randomAccessFile.close();
                    throw new Exception("MiniSEED Compression format not supported, must be STEIM1 or STEIM2");
                }
                if (l5 != (long)list.size()) {
                    LogUtil.error(this.getClass(), "Number of decoded samples does not fit expected number of samples: " + l5 + " " + list.size() + " in " + this.getTraceDataFile().toString());
                }
                long l9 = l6 = l3 - l5;
                long l10 = l3;
                if (l9 < l) {
                    l9 = l;
                }
                if (l10 > l2 + l) {
                    l10 = l2 + l;
                }
                for (long i = l9; i < l10; ++i) {
                    floatBuffer.put((float)((Integer)list.get((int)(i - l6))).intValue() * this.getCalibration());
                }
            }
        }
        catch (EOFException eOFException) {
            LogUtil.debug(this.getClass(), "End of file reached: " + this.getTraceDataFile().getName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

