/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model.tracefiles;

import edu.geophys.commons.model.tracefiles.AbstractTraceFile;
import edu.geophys.commons.model.tracefiles.Steim1;
import edu.geophys.commons.model.tracefiles.TraceFileMetadata;
import edu.geophys.commons.model.tracefiles.Utility;
import edu.geophys.commons.util.LogUtil;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;

public class NxTraceFile
extends AbstractTraceFile {
    private final int OFFSET_TO_NUMBER_SAMPLES = 30;

    protected NxTraceFile(TraceFileMetadata traceFileMetadata) {
        super(traceFileMetadata);
    }

    @Override
    protected final void convertToFloat(ByteBuffer byteBuffer, FloatBuffer floatBuffer) {
    }

    @Override
    public void read(FloatBuffer floatBuffer, long l) {
        int n = this.getDataType().byteSize;
        long l2 = floatBuffer.remaining();
        byte[] byArray = new byte[2];
        long l3 = this.getByteOffset();
        boolean bl = this.getDataType().byteOrder.equals(ByteOrder.LITTLE_ENDIAN);
        try {
            long l4;
            long l5;
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.getTraceDataFile(), "r");
            long l6 = l3 + 30L;
            randomAccessFile.seek(l6);
            randomAccessFile.readFully(byArray);
            int n2 = Utility.bytesToInt(byArray[0], byArray[1], bl);
            for (l5 = (long)n2; l5 < l; l5 += (long)n2) {
                l3 += (long)n;
                randomAccessFile.seek(l6 += (long)n);
                randomAccessFile.readFully(byArray);
                n2 = Utility.bytesToInt(byArray[0], byArray[1], bl);
            }
            long l7 = l4 = l3;
            long l8 = l5 - (long)n2;
            long l9 = l2 + l;
            while (l5 < l9) {
                l3 += (long)n;
                randomAccessFile.seek(l6 += (long)n);
                randomAccessFile.readFully(byArray);
                n2 = Utility.bytesToInt(byArray[0], byArray[1], bl);
                l5 += (long)n2;
            }
            l4 = l3;
            long l10 = l4 - l7 + (long)n;
            int n3 = (int)l10 / n;
            int n4 = 64;
            byte[] byArray2 = new byte[n - n4];
            long l11 = l7;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < n3; ++i) {
                randomAccessFile.seek(l11 + (long)n4);
                randomAccessFile.readFully(byArray2);
                l11 += (long)n;
                arrayList.addAll(Steim1.decode(byArray2, bl));
            }
            randomAccessFile.close();
            long l12 = l - l8;
            long l13 = l2 + l12;
            for (long i = l12; i < l13; ++i) {
                floatBuffer.put((float)((Integer)arrayList.get((int)i)).intValue() * this.getCalibration());
            }
        }
        catch (Exception exception) {
            LogUtil.error(this.getClass(), exception.getMessage());
            exception.printStackTrace();
        }
    }
}

