/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model.tracefiles;

import edu.geophys.commons.model.tracefiles.Utility;
import edu.geophys.commons.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class Steim1 {
    public static List<Integer> decode(byte[] byArray, boolean bl, int n) throws Exception {
        if (byArray.length % 64 != 0) {
            throw new Exception("encoded data length is not multiple of 64 bytes (" + byArray.length + ")");
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = byArray.length / 64;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i < n2; ++i) {
            int[] nArray = Steim1.extractSamples(byArray, i * 64, bl);
            n6 = 0;
            if (i == 0) {
                n7 = n;
                n4 = nArray[1];
                n5 = nArray[2];
                n6 = 3;
                if (n == 0) {
                    n7 = n4 - nArray[3];
                }
            }
            for (int j = n6; j < nArray.length; ++j) {
                arrayList.add(n7 += nArray[j]);
                ++n3;
            }
        }
        return arrayList;
    }

    public static List<Integer> decode(byte[] byArray, boolean bl) throws Exception {
        return Steim1.decode(byArray, bl, 0);
    }

    protected static int[] extractSamples(byte[] byArray, int n, boolean bl) {
        int n2 = Utility.bytesToInt(byArray[n], byArray[n + 1], byArray[n + 2], byArray[n + 3], bl);
        int n3 = 0;
        int[] nArray = new int[64];
        int n4 = 0;
        block6: for (int i = 0; i < 16; ++i) {
            n3 = n2 >> 30 - i * 2 & 3;
            switch (n3) {
                case 0: {
                    if (n != 0 || i >= 3) continue block6;
                    nArray[n4++] = Utility.bytesToInt(byArray[n + i * 4], byArray[n + i * 4 + 1], byArray[n + i * 4 + 2], byArray[n + i * 4 + 3], bl);
                    continue block6;
                }
                case 1: {
                    int n5;
                    for (n5 = 0; n5 < 4; ++n5) {
                        nArray[n4] = Utility.bytesToInt(byArray[n + i * 4 + n5]);
                        ++n4;
                    }
                    continue block6;
                }
                case 2: {
                    int n5;
                    for (n5 = 0; n5 < 4; n5 += 2) {
                        nArray[n4] = Utility.bytesToInt(byArray[n + i * 4 + n5], byArray[n + i * 4 + n5 + 1], bl);
                        ++n4;
                    }
                    continue block6;
                }
                case 3: {
                    nArray[n4++] = Utility.bytesToInt(byArray[n + i * 4], byArray[n + i * 4 + 1], byArray[n + i * 4 + 2], byArray[n + i * 4 + 3], bl);
                    continue block6;
                }
            }
        }
        int[] nArray2 = new int[n4];
        System.arraycopy(nArray, 0, nArray2, 0, n4);
        return nArray2;
    }

    public static void main(String[] stringArray) throws Exception {
        int n = 0;
        File file = new File("/home/share/data/Testsets/data/bfo_0521.bhz");
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[4032];
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = 0;
        while ((long)n2 <= file.length() - 4096L) {
            int n3;
            FileUtil.skipFully(fileInputStream, 64L);
            int n4 = 0;
            for (n3 = 0; n3 < byArray.length && (n4 = ((InputStream)fileInputStream).read(byArray, n3, byArray.length - n3)) >= 0; n3 += n4) {
            }
            if (n3 < byArray.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
            arrayList.addAll(Steim1.decode(byArray, false, n));
            boolean bl = false;
            n2 += 4096;
        }
        ((InputStream)fileInputStream).close();
        System.out.println(arrayList.get(0) + " " + arrayList.get(arrayList.size() - 1));
        System.out.println(64);
    }
}

