/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model.tracefiles.converters;

import edu.geophys.commons.model.tracefiles.converters.TimeHelper;
import edu.geophys.commons.util.DateTimeUtil;
import java.util.Calendar;
import java.util.Locale;

public class HeaderLine {
    private String date;
    private double epoch;
    private String stat;
    private String chan;
    private long nsamp;
    private float samprate;
    private float calibm;
    private float calper;
    private String dattyp;
    private String directory;
    private String filename;
    private long byteOffset;

    public HeaderLine(String string, double d, String string2, String string3, long l, float f, float f2, float f3, String string4, String string5, String string6, long l2) {
        this.date = string;
        this.epoch = d;
        this.stat = string2;
        this.chan = string3;
        this.nsamp = l;
        this.samprate = f;
        this.calibm = f2;
        this.calper = f3;
        this.dattyp = string4;
        this.directory = string5;
        this.filename = string6;
        this.byteOffset = l2;
    }

    public HeaderLine(double d, String string, String string2, long l, float f, float f2, float f3, String string3, String string4, int n) {
        this(d, string, string2, l, f, f2, f3, string3, string4, string + "_" + string2 + "-" + DateTimeUtil.formatDateTimeOnlynumbersHighPrecision((long)(d * 1000.0)) + "-" + DateTimeUtil.formatDateTimeOnlynumbersHighPrecision((long)(d * 1000.0) + (long)((float)(l * 1000L) / f)) + ".dat".replaceAll(" ", ""), n);
    }

    public HeaderLine(double d, String string, String string2, long l, float f, float f2, float f3, String string3, String string4, String string5, int n) {
        this.epoch = d;
        this.stat = string;
        this.chan = string2;
        this.nsamp = l;
        this.samprate = f;
        this.calibm = f2;
        this.calper = f3;
        this.dattyp = string3;
        this.directory = string4;
        this.byteOffset = n;
        Calendar calendar = TimeHelper.epochToCalendar(d);
        this.date = String.format(Locale.ENGLISH, "%1$tY%1$tj", calendar);
        this.filename = string5;
    }

    public String getLine() {
        return String.format(Locale.ENGLISH, "%s %2$#f %3$s %4$s %5$d %6$#.2f %7$#f %8$#f %9$s %10$s %11$s %12$d\n", this.date, this.epoch, this.stat, this.chan, this.nsamp, Float.valueOf(this.samprate), Float.valueOf(this.calibm), Float.valueOf(this.calper), this.dattyp, this.directory, this.filename, this.byteOffset);
    }

    public String getC30Line() {
        return String.format("%-6s %-8s %17.5f %8d %8d %8s %17.5f %8d %11.7f%16.6f %16.6f %-6s %-1s %-2s %-1s %-64s %-32s%10d %8d %-17s\n", this.stat, this.chan, this.epoch, -1, -1, this.date, this.epoch + (double)this.nsamp / (double)this.samprate, this.nsamp, Float.valueOf(this.samprate), Float.valueOf(this.calibm), Float.valueOf(this.calper), "LE-D", "-", this.dattyp, "-", this.directory, this.filename, this.byteOffset, -1, DateTimeUtil.formatDateCSS((long)(this.epoch * 1000.0)));
    }

    public String toString() {
        return "HeaderLine [date=" + this.date + ", epoch=" + this.epoch + ", stat=" + this.stat + ", chan=" + this.chan + ", nsamp=" + this.nsamp + ", samprate=" + this.samprate + ", calibm=" + this.calibm + ", calper=" + this.calper + ", dattyp=" + this.dattyp + ", directory=" + this.directory + ", filename=" + this.filename + ", byteOffset=" + this.byteOffset + "]";
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String string) {
        this.date = string;
    }

    public double getEpoch() {
        return this.epoch;
    }

    public void setEpoch(double d) {
        this.epoch = d;
    }

    public String getStat() {
        return this.stat;
    }

    public void setStat(String string) {
        this.stat = string;
    }

    public String getChan() {
        return this.chan;
    }

    public void setChan(String string) {
        this.chan = string;
    }

    public long getNsamp() {
        return this.nsamp;
    }

    public void setNsamp(long l) {
        this.nsamp = l;
    }

    public float getSamprate() {
        return this.samprate;
    }

    public void setSamprate(float f) {
        this.samprate = f;
    }

    public float getCalibm() {
        return this.calibm;
    }

    public void setCalibm(float f) {
        this.calibm = f;
    }

    public float getCalper() {
        return this.calper;
    }

    public void setCalper(float f) {
        this.calper = f;
    }

    public String getDattyp() {
        return this.dattyp;
    }

    public void setDattyp(String string) {
        this.dattyp = string;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String string) {
        this.directory = string;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public long getByteOffset() {
        return this.byteOffset;
    }

    public void setByteOffset(long l) {
        this.byteOffset = l;
    }
}

