/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model.tracefiles.converters;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class TimeHelper {
    public static final double ONE_SECOND_DOUBLE = 1.0;
    public static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");
    private static final String FORMAT_STRING_TIME = "HH:mm:ss";
    private static final String FORMAT_STRING_TIME_HIGH_PRECISION = "HH:mm:ss.SSS";
    private static final DateFormat FORMAT_UTC_TIME_HIGH_PRECISION = new SimpleDateFormat("HH:mm:ss.SSS");
    private static final DateFormat FORMAT_UTC_TIME = new SimpleDateFormat("HH:mm:ss");
    private static final DateFormat FORMAT_UTC_DATE = DateFormat.getDateInstance(3);
    private static final Calendar TMP_CALENDAR_UTC_TIME;
    private static final Calendar TMP_CALENDAR_UTC_DATE;
    private static final Calendar TMP_CALENDAR_UTC_DATETIME;

    public static final long doubleSecondsToLongMilliseconds(double d) {
        double d2 = Math.floor(d);
        double d3 = d - d2;
        long l = (long)Math.floor(d2 *= 1000.0) + (long)Math.floor(d3 *= 1000.0);
        return l;
    }

    public static final double longMillisecondsToDoubleSeconds(long l) {
        long l2 = l / 1000L;
        double d = l2;
        double d2 = l - l2 * 1000L;
        return d += (d2 /= 1000.0);
    }

    public static final double longMillisecondsToDoubleSeconds(long l, double d) {
        return TimeHelper.longMillisecondsToDoubleSeconds(l) + d;
    }

    public static final double calendarToEpoch(Calendar calendar) {
        return TimeHelper.longMillisecondsToDoubleSeconds(calendar.getTimeInMillis());
    }

    public static final double calendarToEpoch(Calendar calendar, double d) {
        return TimeHelper.longMillisecondsToDoubleSeconds(calendar.getTimeInMillis(), d);
    }

    public static final Calendar epochToCalendar(double d) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        return TimeHelper.epochToCalendar(d, gregorianCalendar);
    }

    public static final Calendar epochToCalendar(double d, Calendar calendar) {
        Calendar calendar2 = calendar;
        calendar2.setTimeZone(TIMEZONE_UTC);
        calendar2.setTimeInMillis(TimeHelper.doubleSecondsToLongMilliseconds(d));
        calendar2.get(5);
        return calendar2;
    }

    public static final String formatTimeHighPrecisonUTC(Calendar calendar) {
        return FORMAT_UTC_TIME_HIGH_PRECISION.format(calendar.getTime());
    }

    public static final String formatTimeHighPrecisonUTC(double d) {
        return TimeHelper.formatTimeHighPrecisonUTC(TimeHelper.epochToCalendar(d, TMP_CALENDAR_UTC_TIME));
    }

    public static final String formatTimeUTC(Calendar calendar) {
        return FORMAT_UTC_TIME.format(calendar.getTime());
    }

    public static final String formatTimeUTC(double d) {
        return TimeHelper.formatTimeUTC(TimeHelper.epochToCalendar(d, TMP_CALENDAR_UTC_TIME));
    }

    public static final String formatDateUTC(Calendar calendar) {
        return FORMAT_UTC_DATE.format(calendar.getTime());
    }

    public static final String formatDateUTC(double d) {
        return TimeHelper.formatDateUTC(TimeHelper.epochToCalendar(d, TMP_CALENDAR_UTC_DATE));
    }

    public static final String formatDateTimeUTC(Calendar calendar) {
        Date date = calendar.getTime();
        StringBuffer stringBuffer = new StringBuffer(FORMAT_UTC_DATE.format(date));
        stringBuffer.append(" ");
        stringBuffer.append(FORMAT_UTC_TIME.format(date));
        return stringBuffer.toString();
    }

    public static final String formatDateTimeUTC(double d) {
        return TimeHelper.formatDateTimeUTC(TimeHelper.epochToCalendar(d, TMP_CALENDAR_UTC_DATETIME));
    }

    public static final double determineIncerment(double d) {
        double d2 = d <= 1.0 ? 1.0 : (d <= 2.0 ? 2.0 : (d <= 5.0 ? 5.0 : (d <= 12.0 ? 10.0 : (d <= 30.0 ? 30.0 : (d <= 60.0 ? 60.0 : (d <= 120.0 ? 120.0 : (d <= 300.0 ? 300.0 : (d <= 600.0 ? 600.0 : (d <= 1200.0 ? 1200.0 : (d <= 3600.0 ? 3600.0 : (d <= 7200.0 ? 7200.0 : (d <= 14400.0 ? 14400.0 : (d <= 28800.0 ? 28800.0 : (d <= 86400.0 ? 86400.0 : (d <= 172800.0 ? 172800.0 : (d <= 432000.0 ? 432000.0 : (d <= 864000.0 ? 864000.0 : (d <= 2592000.0 ? 2592000.0 : (d <= 5184000.0 ? 5184000.0 : (d <= 1.0368E7 ? 1.0368E7 : (d <= 2.0736E7 ? 2.0736E7 : 4.1472E7)))))))))))))))))))));
        return d2;
    }

    public static final double floor(double d, double d2) {
        return Math.floor(d / d2) * d2;
    }

    public static final double ceil(double d, double d2) {
        double d3 = TimeHelper.floor(d, d2);
        if (d != d3) {
            d3 += d2;
        }
        return d3;
    }

    static {
        FORMAT_UTC_TIME_HIGH_PRECISION.setTimeZone(TIMEZONE_UTC);
        FORMAT_UTC_TIME.setTimeZone(TIMEZONE_UTC);
        FORMAT_UTC_DATE.setTimeZone(TIMEZONE_UTC);
        TMP_CALENDAR_UTC_TIME = new GregorianCalendar(TIMEZONE_UTC);
        TMP_CALENDAR_UTC_DATE = new GregorianCalendar(TIMEZONE_UTC);
        TMP_CALENDAR_UTC_DATETIME = new GregorianCalendar(TIMEZONE_UTC);
    }
}

