/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model.tracefiles.converters.seg2;

import edu.geophys.commons.model.tracefiles.converters.seg2.Seg2MetaModel;
import edu.geophys.commons.model.tracefiles.converters.seg2.Seg2TraceMetaModel;
import edu.geophys.commons.util.LogUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class Seg2File
extends RandomAccessFile {
    private final int REVISION_START = 2;
    private final int POINTER_BLOCK_START = 32;
    private static final Pattern SPLIT_STRING = Pattern.compile("(\\s)+");
    private boolean _valid = false;

    public Seg2File(File file) throws FileNotFoundException, IOException {
        super(file, "r");
        this._valid = Short.reverseBytes(this.readShort()) == 14933;
    }

    private Seg2File(File file, String string) throws FileNotFoundException {
        super(file, string);
    }

    private Seg2File(String string, String string2) throws FileNotFoundException {
        super(string, string2);
    }

    public boolean isValid() {
        return this._valid;
    }

    private String readString() throws IOException {
        short s = Short.reverseBytes(this.readShort());
        if (s == 0) {
            return null;
        }
        char[] cArray = new char[s - 2];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)this.readByte();
        }
        String string = String.valueOf(cArray).trim();
        return string;
    }

    private Map<String, String> parseStringBlock() throws IOException {
        String string;
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        while ((string = this.readString()) != null) {
            String[] stringArray = SPLIT_STRING.split(string, 2);
            if (stringArray.length == 2) {
                treeMap.put(stringArray[0], stringArray[1].trim());
                continue;
            }
            if (stringArray.length == 1) {
                treeMap.put(stringArray[0], "");
                continue;
            }
            LogUtil.error(this.getClass(), "Problem reading seg-2 header line");
        }
        return treeMap;
    }

    private Seg2MetaModel readFileMetadata() throws IOException {
        int n;
        if (!this.isValid()) {
            throw new IOException("Could not read from invalid file");
        }
        this.seek(2L);
        short s = Short.reverseBytes(this.readShort());
        short s2 = Short.reverseBytes(this.readShort());
        short s3 = Short.reverseBytes(this.readShort());
        short s4 = this.readByte();
        short s5 = this.readShort();
        this.seek(32L);
        int[] nArray = new int[s3];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = Integer.reverseBytes(this.readInt());
        }
        Seg2MetaModel seg2MetaModel = new Seg2MetaModel(s3);
        seg2MetaModel.setRevision(s);
        this.seek(32 + s2);
        seg2MetaModel.setFileDescription(this.parseStringBlock());
        for (n = 0; n < nArray.length; ++n) {
            this.seek(nArray[n]);
            this.readTraceHeader(seg2MetaModel.getChild(n));
        }
        return seg2MetaModel;
    }

    private void readTraceHeader(Seg2TraceMetaModel seg2TraceMetaModel) throws IOException {
        int n = (int)this.getFilePointer();
        short s = Short.reverseBytes(this.readShort());
        if (s != 17442) {
            throw new IOException("Trace header expected at " + n);
        }
        short s2 = Short.reverseBytes(this.readShort());
        int n2 = Integer.reverseBytes(this.readInt());
        int n3 = Integer.reverseBytes(this.readInt());
        byte by = this.readByte();
        this.seek(n + 32);
        Map<String, String> map = this.parseStringBlock();
        seg2TraceMetaModel.setOffset(n + s2);
        seg2TraceMetaModel.setLength(n2);
        seg2TraceMetaModel.setSamples(n3);
        seg2TraceMetaModel.setDataFormatCode(by);
        seg2TraceMetaModel.setTraceDescription(map);
    }

    public Seg2MetaModel readMetaData() throws IOException {
        return this.readFileMetadata();
    }
}

