/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model.tracefiles.converters.seg2;

import edu.geophys.commons.model.tracefiles.converters.seg2.Seg2File;
import edu.geophys.commons.model.tracefiles.converters.seg2.Seg2MetaModel;
import edu.geophys.commons.util.LogUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;

public class Seg2ToCSS {
    private ArrayList<File> _srcFiles = new ArrayList();
    private ArrayList<File> _srcValidFiles = new ArrayList();
    private ArrayList<Seg2MetaModel> _srcMetaData = new ArrayList();
    private ArrayList<Integer> _sortedIds = new ArrayList();
    private String[] channels;
    private File header;
    private float calper;
    private float calibm;
    private int lsbFactor;

    public void convert(File file, File file2, float f, float f2, int n, String[] stringArray, boolean bl) {
        this.header = file2;
        this.channels = stringArray;
        this.calper = f;
        this.calibm = f2;
        this.lsbFactor = n;
        if (!file.exists() || !file.isDirectory()) {
            LogUtil.error(this.getClass(), "Directory (" + file.getAbsolutePath() + ") does not exist or is no directory.", true);
            return;
        }
        if (file2.exists()) {
            LogUtil.error(this.getClass(), "Headerfile (" + file2.getAbsolutePath() + ") already exists.", true);
            return;
        }
        LogUtil.info(this.getClass(), "Step 2: Collecting input files:");
        for (File object2 : FileUtils.listFiles((File)file, null, (boolean)bl)) {
            this.addDataFile(object2.getAbsolutePath());
        }
        LogUtil.info(this.getClass(), "Done.\n");
        LogUtil.info(this.getClass(), "Step 3: Importing input files:");
        for (File file3 : this._srcFiles) {
            Seg2MetaModel seg2MetaModel = this.importFile(file3);
            if (seg2MetaModel == null) continue;
            this._srcMetaData.add(seg2MetaModel);
            this._srcValidFiles.add(file3);
            LogUtil.info(this.getClass(), seg2MetaModel.getInfo());
        }
        LogUtil.info(this.getClass(), "Done.\n");
        LogUtil.info(this.getClass(), "Step 4: Sorting input files:");
        TreeSet<Seg2MetaModel> treeSet = new TreeSet<Seg2MetaModel>(this._srcMetaData);
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            Seg2MetaModel seg2MetaModel = (Seg2MetaModel)iterator.next();
            this._sortedIds.add(this._srcMetaData.indexOf(seg2MetaModel));
        }
        LogUtil.info(this.getClass(), "Done.\n");
        LogUtil.info(this.getClass(), "Step 5: Generating header:");
        for (Integer n2 : this._sortedIds) {
            this.generateHeader(this._srcValidFiles.get(n2), this._srcMetaData.get(n2));
        }
        LogUtil.info(this.getClass(), "Done.\n");
    }

    private final void addDataFile(String string) {
        File file = new File(string);
        if (!file.exists() || file.isDirectory()) {
            LogUtil.warn(this.getClass(), String.format("File does not exist \"%s\"", file));
            return;
        }
        if (!file.canRead()) {
            LogUtil.warn(this.getClass(), String.format("File is not readable \"%s\"", file));
            return;
        }
        if (this._srcFiles.contains(file)) {
            LogUtil.warn(this.getClass(), String.format("File is a duplicate \"%s\"", file));
            return;
        }
        this._srcFiles.add(file);
    }

    private void generateHeader(File file, Seg2MetaModel seg2MetaModel) {
        String string = seg2MetaModel.getSHTPart(this.channels, file.getParent(), file.getName(), this.calibm, this.calper, this.lsbFactor);
        LogUtil.info(this.getClass(), string);
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.header, true));
            bufferedWriter.append(string);
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private Seg2MetaModel importFile(File file) {
        File file2 = file;
        Seg2MetaModel seg2MetaModel = null;
        LogUtil.info(this.getClass(), String.format("Generate header part of file \"%s\"", file));
        try {
            Seg2File seg2File = new Seg2File(file2);
            if (!seg2File.isValid()) {
                LogUtil.error(this.getClass(), String.format("File is not valid SEG2 formated \"%s\"", file2));
                seg2File.close();
                return null;
            }
            LogUtil.info(this.getClass(), String.format("Importing: \"%s\"", file2));
            seg2MetaModel = seg2File.readMetaData();
            LogUtil.info(this.getClass(), seg2MetaModel.getInfo());
            seg2File.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            LogUtil.error(this.getClass(), "File not found!");
            fileNotFoundException.printStackTrace();
            return null;
        }
        catch (IOException iOException) {
            LogUtil.error(this.getClass(), String.format("Unknown error while importing file \"%s\"", file2));
            iOException.printStackTrace();
            return null;
        }
        return seg2MetaModel;
    }
}

