/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.range;

import edu.geophys.commons.range.AbstractRangeMarkerModel;
import edu.geophys.commons.range.RangeMarker;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;

public class DefaultRangeMarkerModel<E>
extends AbstractRangeMarkerModel<E> {
    protected HashMap<String, RangeMarker<E>> _mapedMarkers = new HashMap();
    protected TreeSet<RangeMarker<E>> _sortedMarkers = new TreeSet(new RangeMarker.RangeMarkerNaturalOrder());

    @Override
    public void clearMarker(String string) {
        RangeMarker<E> rangeMarker = this._mapedMarkers.remove(string);
        if (rangeMarker != null) {
            this._sortedMarkers.remove(rangeMarker);
            this.fireMarkerRemoved(rangeMarker);
        }
    }

    @Override
    public RangeMarker<E> getMarker(String string) {
        return this._mapedMarkers.get(string);
    }

    @Override
    public String[] getSortedIds() {
        String[] stringArray = new String[this._sortedMarkers.size()];
        int n = 0;
        for (RangeMarker<E> rangeMarker : this._sortedMarkers) {
            stringArray[n++] = rangeMarker.getID();
        }
        return stringArray;
    }

    @Override
    public int getMarkerCount() {
        return this._mapedMarkers.size();
    }

    @Override
    public SortedSet<RangeMarker<E>> getSortedMarkers() {
        return new TreeSet<RangeMarker<E>>(this._sortedMarkers);
    }

    @Override
    public void moveMarker(double d, String ... stringArray) {
        for (String string : stringArray) {
            RangeMarker<E> rangeMarker = this.getMarker(string);
            if (rangeMarker == null) continue;
            this.changeMarker(rangeMarker, rangeMarker.getPosition() + d, rangeMarker.getValue());
        }
        this.fireAllChanged();
    }

    @Override
    public void setMarker(String string, double d, E e) {
        if (this._mapedMarkers.containsKey(string)) {
            RangeMarker<E> rangeMarker = this._mapedMarkers.get(string);
            boolean bl = rangeMarker.getPosition() != d;
            boolean bl2 = rangeMarker.getValue() != e;
            this.changeMarker(rangeMarker, d, e);
            if (bl) {
                this.fireMarkerPositionChanged(rangeMarker);
            }
            if (bl2) {
                this.fireMarkerValueChanged(rangeMarker);
            }
        } else {
            RangeMarker<E> rangeMarker = this.addNewMarker(string, d, e);
            this.fireMarkerAdded(rangeMarker);
        }
    }

    protected final void changeMarker(RangeMarker<E> rangeMarker, double d, E e) {
        rangeMarker.setPosition(d);
        rangeMarker.setValue(e);
        this._sortedMarkers.remove(rangeMarker);
        this._sortedMarkers.add(rangeMarker);
    }

    protected final RangeMarker<E> addNewMarker(String string, double d, E e) {
        RangeMarker<E> rangeMarker = new RangeMarker<E>(this, string, d, e);
        this._mapedMarkers.put(string, rangeMarker);
        this._sortedMarkers.add(rangeMarker);
        return rangeMarker;
    }

    protected final void clearAllMarkers() {
        this._mapedMarkers.clear();
        this._sortedMarkers.clear();
    }
}

