/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.resamplingmodes;

public class ResamplingMode {
    private final String description;
    private final float masterSamplingRate;
    private final int sonogramIncrement;
    private final int sonogramFrequencyBins;
    private final long baseSelectionLengthMs;
    private static final double[] SELECTION_LENGTH_MULTI = new double[]{0.3333333333333333, 0.5, 0.6666666666666666, 1.0, 1.5, 2.0, 3.0};
    private static final int DEFAULT_SELECTION_LENGTH_MULTI_INDEX = 3;

    public String toString(boolean bl) {
        String string = String.format("%.0f Hz " + this.description, Float.valueOf(this.masterSamplingRate));
        if (bl) {
            return "<html><b>" + string + "</b><br>sonogram increment: " + this.sonogramIncrement + " samples<br>sonogram frequency bins: " + this.sonogramFrequencyBins + "<br>base selection length: " + (double)this.baseSelectionLengthMs / 1000.0 + "s</html>";
        }
        return string;
    }

    public String toString() {
        return this.toString(false);
    }

    public long getSelectionLengthMs() {
        return this.baseSelectionLengthMs;
    }

    public long getSelectionLengthMs(int n) {
        int n2 = Math.min(Math.max(0, n + 3), SELECTION_LENGTH_MULTI.length);
        return (long)((double)this.baseSelectionLengthMs * SELECTION_LENGTH_MULTI[n2]);
    }

    public int getMinSelectionModeIndex() {
        return -3;
    }

    public int getMaxSelectionModeIndex() {
        return SELECTION_LENGTH_MULTI.length - 1 - 3;
    }

    public int getSelectionIndexByMs(double d) {
        float f = (float)d / (float)this.baseSelectionLengthMs;
        int n = this.getMinSelectionModeIndex();
        int n2 = this.getMaxSelectionModeIndex();
        if (f < (float)((int)(0.95 * SELECTION_LENGTH_MULTI[0]))) {
            return n - 1;
        }
        if (f > (float)((int)(1.05 * SELECTION_LENGTH_MULTI[SELECTION_LENGTH_MULTI.length - 1]))) {
            return n2 + 1;
        }
        double d2 = -1.0;
        double d3 = -1.0;
        for (int i = 0; i < SELECTION_LENGTH_MULTI.length; ++i) {
            d3 = Math.abs(SELECTION_LENGTH_MULTI[i] - (double)f);
            if (d2 >= 0.0 && d2 < d3) {
                return i - 1 - 3;
            }
            d2 = d3;
        }
        return n2;
    }

    public float getMasterSamplingRate() {
        return this.masterSamplingRate;
    }

    public int getSonogramIncrement() {
        return this.sonogramIncrement;
    }

    public int getSonogramFrequencyBins() {
        return this.sonogramFrequencyBins;
    }

    public double getSonoPxFactor(ResamplingMode resamplingMode) {
        return resamplingMode.getMasterSamplingRate() * (float)this.getSonogramIncrement() / (this.getMasterSamplingRate() * (float)resamplingMode.getSonogramIncrement());
    }

    public ResamplingMode(String string, float f, int n, int n2, long l) {
        this.description = string;
        this.masterSamplingRate = f;
        this.sonogramIncrement = n;
        this.sonogramFrequencyBins = n2;
        this.baseSelectionLengthMs = l;
    }

    public float getSecPerSonoPixel() {
        return (float)this.sonogramIncrement / (2.0f * this.masterSamplingRate);
    }
}

