/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.themes;

import com.formdev.flatlaf.FlatLaf;
import edu.geophys.commons.themes.DarkTheme;
import edu.geophys.commons.themes.LightTheme;
import edu.geophys.commons.themes.SuiteTheme;

public class ThemeManager {
    private static final ThemeManager INSTANCE = new ThemeManager();
    private ThemeMode mode = ThemeMode.DARK;
    private SuiteTheme theme;

    private ThemeManager() {
        FlatLaf.registerCustomDefaultsSource((String)"edu.geophys.commons.themes");
        this.update();
    }

    public static ThemeManager getInstance() {
        return INSTANCE;
    }

    public void update() {
        switch (this.mode) {
            case DARK: {
                this.theme = new DarkTheme();
                break;
            }
            case LIGHT: {
                this.theme = new LightTheme();
            }
        }
        this.theme.init();
    }

    public void setMode(ThemeMode themeMode) {
        if (this.mode != themeMode) {
            this.mode = themeMode;
            this.update();
        }
    }

    public SuiteTheme getTheme() {
        return this.theme;
    }

    public static enum ThemeMode {
        DARK,
        LIGHT;

    }
}

