/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.ui;

import java.awt.Graphics2D;
import java.awt.Rectangle;

public abstract class AbstractBasicPainter<T> {
    public final void paint(Graphics2D graphics2D, T t) {
        this.paint(graphics2D, graphics2D.getClipBounds().x, graphics2D.getClipBounds().y, graphics2D.getClipBounds().width, graphics2D.getClipBounds().height, t);
    }

    public final void paint(Graphics2D graphics2D, Rectangle rectangle, T t) {
        this.paint(graphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height, t);
    }

    public final void paint(Graphics2D graphics2D, int n, int n2, int n3, int n4, T t) {
        this.preparePaint(graphics2D, n, n2, n3, n4, t);
    }

    public final Rectangle getPaintingArea(int n, int n2, int n3, int n4, T t) {
        Rectangle rectangle = this.calcPaintingArea(n3, n4, t);
        if (rectangle != null) {
            rectangle.x += n - 1;
            rectangle.y += n2 - 1;
            rectangle.width += 2;
            rectangle.height += 2;
        } else {
            rectangle = new Rectangle(n, n2, n3, n4);
        }
        return rectangle;
    }

    protected void preparePaint(Graphics2D graphics2D, int n, int n2, int n3, int n4, T t) {
        this.doBasicPaint(graphics2D, n3, n4, t);
    }

    protected Rectangle calcPaintingArea(int n, int n2, T t) {
        return null;
    }

    protected abstract void doBasicPaint(Graphics2D var1, int var2, int var3, T var4);
}

